/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class LineContains
extends BaseParamFilterReader
implements ChainableReader {
    private static final String CONTAINS_KEY = "contains";
    private static final String NEGATE_KEY = "negate";
    private Vector contains = new Vector();
    private String line = null;
    private boolean negate = false;

    public LineContains() {
    }

    public LineContains(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.line != null) {
            n = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            int n2 = this.contains.size();
            this.line = this.readLine();
            while (this.line != null) {
                boolean bl = true;
                for (int i = 0; bl && i < n2; ++i) {
                    String string = (String)this.contains.elementAt(i);
                    bl = this.line.indexOf(string) >= 0;
                }
                if (bl ^ this.isNegated()) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return n;
    }

    public void addConfiguredContains(Contains contains) {
        this.contains.addElement(contains.getValue());
    }

    public void setNegate(boolean bl) {
        this.negate = bl;
    }

    public boolean isNegated() {
        return this.negate;
    }

    private void setContains(Vector vector) {
        this.contains = vector;
    }

    private Vector getContains() {
        return this.contains;
    }

    @Override
    public Reader chain(Reader reader) {
        LineContains lineContains = new LineContains(reader);
        lineContains.setContains(this.getContains());
        lineContains.setNegate(this.isNegated());
        return lineContains;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (CONTAINS_KEY.equals(parameterArray[i].getType())) {
                    this.contains.addElement(parameterArray[i].getValue());
                    continue;
                }
                if (!NEGATE_KEY.equals(parameterArray[i].getType())) continue;
                this.setNegate(Project.toBoolean(parameterArray[i].getValue()));
            }
        }
    }

    public static class Contains {
        private String value;

        public final void setValue(String string) {
            this.value = string;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

