/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;

public class EscapeUnicode
extends BaseParamFilterReader
implements ChainableReader {
    private StringBuffer unicodeBuf = new StringBuffer();

    public EscapeUnicode() {
    }

    public EscapeUnicode(Reader reader) {
        super(reader);
    }

    @Override
    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.unicodeBuf.length() == 0) {
            char c;
            n = this.in.read();
            if (n != -1 && (c = (char)n) >= '\u0080') {
                this.unicodeBuf = new StringBuffer("u0000");
                String string = Integer.toHexString(n);
                for (int i = 0; i < string.length(); ++i) {
                    this.unicodeBuf.setCharAt(this.unicodeBuf.length() - string.length() + i, string.charAt(i));
                }
                n = 92;
            }
        } else {
            n = this.unicodeBuf.charAt(0);
            this.unicodeBuf.deleteCharAt(0);
        }
        return n;
    }

    @Override
    public final Reader chain(Reader reader) {
        EscapeUnicode escapeUnicode = new EscapeUnicode(reader);
        escapeUnicode.setInitialized(true);
        return escapeUnicode;
    }

    private void initialize() {
    }
}

