/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.UnsupportedElementException;
import org.apache.tools.ant.taskdefs.PreSetDef;

public class UnknownElement
extends Task {
    private String elementName;
    private String namespace = "";
    private String qname;
    private Object realThing;
    private List children = null;
    private boolean presetDefed = false;

    public UnknownElement(String string) {
        this.elementName = string;
    }

    public List getChildren() {
        return this.children;
    }

    public String getTag() {
        return this.elementName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        if (string.equals("ant:current")) {
            ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
            string = componentHelper.getCurrentAntlibUri();
        }
        this.namespace = string == null ? "" : string;
    }

    public String getQName() {
        return this.qname;
    }

    public void setQName(String string) {
        this.qname = string;
    }

    @Override
    public RuntimeConfigurable getWrapper() {
        return super.getWrapper();
    }

    @Override
    public void maybeConfigure() throws BuildException {
        if (this.realThing != null) {
            return;
        }
        this.configure(this.makeObject(this, this.getWrapper()));
    }

    public void configure(Object object) {
        this.realThing = object;
        this.getWrapper().setProxy(this.realThing);
        Task task = null;
        if (this.realThing instanceof Task) {
            task = (Task)this.realThing;
            task.setRuntimeConfigurableWrapper(this.getWrapper());
            if (this.getWrapper().getId() != null) {
                this.getOwningTarget().replaceChild((Task)this, (Task)this.realThing);
            }
        }
        if (task != null) {
            task.maybeConfigure();
        } else {
            this.getWrapper().maybeConfigure(this.getProject());
        }
        this.handleChildren(this.realThing, this.getWrapper());
    }

    @Override
    protected void handleOutput(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleOutput(string);
        } else {
            super.handleOutput(string);
        }
    }

    @Override
    protected int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.realThing instanceof Task) {
            return ((Task)this.realThing).handleInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    @Override
    protected void handleFlush(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleFlush(string);
        } else {
            super.handleFlush(string);
        }
    }

    @Override
    protected void handleErrorOutput(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    @Override
    protected void handleErrorFlush(String string) {
        if (this.realThing instanceof Task) {
            ((Task)this.realThing).handleErrorOutput(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.realThing == null) {
            throw new BuildException("Could not create task of type: " + this.elementName, this.getLocation());
        }
        try {
            if (this.realThing instanceof Task) {
                ((Task)this.realThing).execute();
            }
        }
        finally {
            if (this.getWrapper().getId() == null) {
                this.realThing = null;
                this.getWrapper().setProxy(null);
            }
        }
    }

    public void addChild(UnknownElement unknownElement) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(unknownElement);
    }

    protected void handleChildren(Object object, RuntimeConfigurable runtimeConfigurable) throws BuildException {
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        String string = this.getNamespace();
        Class<?> clazz = object.getClass();
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(this.getProject(), clazz);
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                RuntimeConfigurable runtimeConfigurable2 = runtimeConfigurable.getChild(n);
                UnknownElement unknownElement = (UnknownElement)iterator.next();
                try {
                    if (!this.handleChild(string, introspectionHelper, object, unknownElement, runtimeConfigurable2)) {
                        if (!(object instanceof TaskContainer)) {
                            introspectionHelper.throwNotSupported(this.getProject(), object, unknownElement.getTag());
                        } else {
                            TaskContainer taskContainer = (TaskContainer)object;
                            taskContainer.addTask(unknownElement);
                        }
                    }
                }
                catch (UnsupportedElementException unsupportedElementException) {
                    throw new BuildException(runtimeConfigurable.getElementTag() + " doesn't support the nested \"" + unsupportedElementException.getElement() + "\" element.", unsupportedElementException);
                }
                ++n;
            }
        }
    }

    protected String getComponentName() {
        return ProjectHelper.genComponentName(this.getNamespace(), this.getTag());
    }

    public void applyPreSet(UnknownElement unknownElement) {
        if (this.presetDefed) {
            return;
        }
        this.getWrapper().applyPreSet(unknownElement.getWrapper());
        if (unknownElement.children != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(unknownElement.children);
            if (this.children != null) {
                arrayList.addAll(this.children);
            }
            this.children = arrayList;
        }
        this.presetDefed = true;
    }

    protected Object makeObject(UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        String string = unknownElement.getComponentName();
        Object object = componentHelper.createComponent(unknownElement, unknownElement.getNamespace(), string);
        if (object == null) {
            throw this.getNotFoundException("task or type", string);
        }
        if (object instanceof PreSetDef.PreSetDefinition) {
            PreSetDef.PreSetDefinition preSetDefinition = (PreSetDef.PreSetDefinition)object;
            if ((object = preSetDefinition.createObject(unknownElement.getProject())) == null) {
                throw this.getNotFoundException("preset " + string, preSetDefinition.getPreSets().getComponentName());
            }
            unknownElement.applyPreSet(preSetDefinition.getPreSets());
            if (object instanceof Task) {
                Task task = (Task)object;
                task.setTaskType(unknownElement.getTaskType());
                task.setTaskName(unknownElement.getTaskName());
                task.init();
            }
        }
        if (object instanceof UnknownElement) {
            object = ((UnknownElement)object).makeObject((UnknownElement)object, runtimeConfigurable);
        }
        if (object instanceof Task) {
            ((Task)object).setOwningTarget(this.getOwningTarget());
        }
        if (object instanceof ProjectComponent) {
            ((ProjectComponent)object).setLocation(this.getLocation());
        }
        return object;
    }

    protected Task makeTask(UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        Task task = this.getProject().createTask(unknownElement.getTag());
        if (task != null) {
            task.setLocation(this.getLocation());
            task.setOwningTarget(this.getOwningTarget());
            task.init();
        }
        return task;
    }

    protected BuildException getNotFoundException(String string, String string2) {
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        String string3 = componentHelper.diagnoseCreationFailure(string2, string);
        return new BuildException(string3, this.getLocation());
    }

    @Override
    public String getTaskName() {
        return this.realThing == null || !(this.realThing instanceof Task) ? super.getTaskName() : ((Task)this.realThing).getTaskName();
    }

    public Task getTask() {
        if (this.realThing instanceof Task) {
            return (Task)this.realThing;
        }
        return null;
    }

    public Object getRealThing() {
        return this.realThing;
    }

    public void setRealThing(Object object) {
        this.realThing = object;
    }

    private boolean handleChild(String string, IntrospectionHelper introspectionHelper, Object object, UnknownElement unknownElement, RuntimeConfigurable runtimeConfigurable) {
        String string2 = ProjectHelper.genComponentName(unknownElement.getNamespace(), unknownElement.getTag());
        if (introspectionHelper.supportsNestedElement(string, string2)) {
            Object object2;
            IntrospectionHelper.Creator creator = introspectionHelper.getElementCreator(this.getProject(), string, object, string2, unknownElement);
            creator.setPolyType(runtimeConfigurable.getPolyType());
            Object object3 = creator.create();
            if (object3 instanceof PreSetDef.PreSetDefinition) {
                object2 = (PreSetDef.PreSetDefinition)object3;
                object3 = creator.getRealObject();
                unknownElement.applyPreSet(((PreSetDef.PreSetDefinition)object2).getPreSets());
            }
            runtimeConfigurable.setCreator(creator);
            runtimeConfigurable.setProxy(object3);
            if (object3 instanceof Task) {
                object2 = (Task)object3;
                ((Task)object2).setRuntimeConfigurableWrapper(runtimeConfigurable);
                ((Task)object2).setTaskName(string2);
                ((Task)object2).setTaskType(string2);
            }
            if (object3 instanceof ProjectComponent) {
                ((ProjectComponent)object3).setLocation(unknownElement.getLocation());
            }
            runtimeConfigurable.maybeConfigure(this.getProject());
            unknownElement.handleChildren(object3, runtimeConfigurable);
            creator.store();
            return true;
        }
        return false;
    }

    public boolean similar(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().getName().equals(object.getClass().getName())) {
            return false;
        }
        UnknownElement unknownElement = (UnknownElement)object;
        if (!UnknownElement.equalsString(this.elementName, unknownElement.elementName)) {
            return false;
        }
        if (!this.namespace.equals(unknownElement.namespace)) {
            return false;
        }
        if (!this.qname.equals(unknownElement.qname)) {
            return false;
        }
        if (!this.getWrapper().getAttributeMap().equals(unknownElement.getWrapper().getAttributeMap())) {
            return false;
        }
        if (!this.getWrapper().getText().toString().equals(unknownElement.getWrapper().getText().toString())) {
            return false;
        }
        if (this.children == null || this.children.size() == 0) {
            return unknownElement.children == null || unknownElement.children.size() == 0;
        }
        if (unknownElement.children == null) {
            return false;
        }
        if (this.children.size() != unknownElement.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            UnknownElement unknownElement2 = (UnknownElement)this.children.get(i);
            if (unknownElement2.similar(unknownElement.children.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsString(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public UnknownElement copy(Project project) {
        Object object;
        UnknownElement unknownElement = new UnknownElement(this.getTag());
        unknownElement.setNamespace(this.getNamespace());
        unknownElement.setProject(project);
        unknownElement.setQName(this.getQName());
        unknownElement.setTaskType(this.getTaskType());
        unknownElement.setTaskName(this.getTaskName());
        unknownElement.setLocation(this.getLocation());
        if (this.getOwningTarget() == null) {
            object = new Target();
            ((Target)object).setProject(this.getProject());
            unknownElement.setOwningTarget((Target)object);
        } else {
            unknownElement.setOwningTarget(this.getOwningTarget());
        }
        object = new RuntimeConfigurable(unknownElement, this.getTaskName());
        ((RuntimeConfigurable)object).setPolyType(this.getWrapper().getPolyType());
        Hashtable hashtable = this.getWrapper().getAttributeMap();
        for (Map.Entry object2 : hashtable.entrySet()) {
            ((RuntimeConfigurable)object).setAttribute((String)object2.getKey(), (String)object2.getValue());
        }
        ((RuntimeConfigurable)object).addText(this.getWrapper().getText().toString());
        Enumeration enumeration = this.getWrapper().getChildren();
        while (enumeration.hasMoreElements()) {
            RuntimeConfigurable runtimeConfigurable = (RuntimeConfigurable)enumeration.nextElement();
            UnknownElement unknownElement2 = (UnknownElement)runtimeConfigurable.getProxy();
            UnknownElement unknownElement3 = unknownElement2.copy(project);
            ((RuntimeConfigurable)object).addChild(unknownElement3.getWrapper());
            unknownElement.addChild(unknownElement3);
        }
        return unknownElement;
    }
}

