/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.dispatch.DispatchUtils;
import org.apache.tools.ant.dispatch.Dispatchable;

public class TaskAdapter
extends Task
implements TypeAdapter {
    private Object proxy;

    public TaskAdapter() {
    }

    public TaskAdapter(Object object) {
        this();
        this.setProxy(object);
    }

    public static void checkTaskClass(Class clazz, Project project) {
        if (!Dispatchable.class.isAssignableFrom(clazz)) {
            try {
                Method method = clazz.getMethod("execute", null);
                if (!Void.TYPE.equals(method.getReturnType())) {
                    String string = "return type of execute() should be void but was \"" + method.getReturnType() + "\" in " + clazz;
                    project.log(string, 1);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string = "No public execute() in " + clazz;
                project.log(string, 0);
                throw new BuildException(string);
            }
            catch (LinkageError linkageError) {
                String string = "Could not load " + clazz + ": " + linkageError;
                project.log(string, 0);
                throw new BuildException(string, linkageError);
            }
        }
    }

    @Override
    public void checkProxyClass(Class clazz) {
        TaskAdapter.checkTaskClass(clazz, this.getProject());
    }

    @Override
    public void execute() throws BuildException {
        Method method;
        try {
            method = this.proxy.getClass().getMethod("setLocation", Location.class);
            if (method != null) {
                method.invoke(this.proxy, this.getLocation());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            this.log("Error setting location in " + this.proxy.getClass(), 0);
            throw new BuildException(exception);
        }
        try {
            method = this.proxy.getClass().getMethod("setProject", Project.class);
            if (method != null) {
                method.invoke(this.proxy, this.getProject());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            this.log("Error setting project in " + this.proxy.getClass(), 0);
            throw new BuildException(exception);
        }
        try {
            DispatchUtils.execute(this.proxy);
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            this.log("Error in " + this.proxy.getClass(), 3);
            throw new BuildException(exception);
        }
    }

    @Override
    public void setProxy(Object object) {
        this.proxy = object;
    }

    @Override
    public Object getProxy() {
        return this.proxy;
    }
}

