/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.util.LoaderUtils;
import org.xml.sax.AttributeList;

public class ProjectHelper {
    public static final String ANT_CORE_URI = "antlib:org.apache.tools.ant";
    public static final String ANT_CURRENT_URI = "ant:current";
    public static final String ANTLIB_URI = "antlib:";
    public static final String ANT_TYPE = "ant-type";
    public static final String HELPER_PROPERTY = "org.apache.tools.ant.ProjectHelper";
    public static final String SERVICE_ID = "META-INF/services/org.apache.tools.ant.ProjectHelper";
    public static final String PROJECTHELPER_REFERENCE = "ant.projectHelper";
    private Vector importStack = new Vector();

    public static void configureProject(Project project, File file) throws BuildException {
        ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
        project.addReference(PROJECTHELPER_REFERENCE, projectHelper);
        projectHelper.parse(project, file);
    }

    public Vector getImportStack() {
        return this.importStack;
    }

    public void parse(Project project, Object object) throws BuildException {
        throw new BuildException("ProjectHelper.parse() must be implemented in a helper plugin " + this.getClass().getName());
    }

    public static ProjectHelper getProjectHelper() throws BuildException {
        ProjectHelper projectHelper;
        block11: {
            projectHelper = null;
            String string = System.getProperty(HELPER_PROPERTY);
            try {
                if (string != null) {
                    projectHelper = ProjectHelper.newHelper(string);
                }
            }
            catch (SecurityException securityException) {
                System.out.println("Unable to load ProjectHelper class \"" + string + " specified in system property " + HELPER_PROPERTY);
            }
            if (projectHelper == null) {
                try {
                    InputStreamReader inputStreamReader;
                    ClassLoader classLoader = LoaderUtils.getContextClassLoader();
                    InputStream inputStream = null;
                    if (classLoader != null) {
                        inputStream = classLoader.getResourceAsStream(SERVICE_ID);
                    }
                    if (inputStream == null) {
                        inputStream = ClassLoader.getSystemResourceAsStream(SERVICE_ID);
                    }
                    if (inputStream == null) break block11;
                    try {
                        inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        inputStreamReader = new InputStreamReader(inputStream);
                    }
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string2 != null && !"".equals(string2)) {
                        projectHelper = ProjectHelper.newHelper(string2);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Unable to load ProjectHelper from service META-INF/services/org.apache.tools.ant.ProjectHelper");
                }
            }
        }
        return projectHelper == null ? new ProjectHelper2() : projectHelper;
    }

    private static ProjectHelper newHelper(String string) throws BuildException {
        ClassLoader classLoader = LoaderUtils.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Class.forName(string);
            }
            return (ProjectHelper)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    public static ClassLoader getContextClassLoader() {
        return LoaderUtils.isContextLoaderAvailable() ? LoaderUtils.getContextClassLoader() : null;
    }

    public static void configure(Object object, AttributeList attributeList, Project project) throws BuildException {
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object.getClass());
        int n = attributeList.getLength();
        for (int i = 0; i < n; ++i) {
            String string = ProjectHelper.replaceProperties(project, attributeList.getValue(i), project.getProperties());
            try {
                introspectionHelper.setAttribute(project, object, attributeList.getName(i).toLowerCase(Locale.US), string);
                continue;
            }
            catch (BuildException buildException) {
                if (attributeList.getName(i).equals("id")) continue;
                throw buildException;
            }
        }
    }

    public static void addText(Project project, Object object, char[] cArray, int n, int n2) throws BuildException {
        ProjectHelper.addText(project, object, new String(cArray, n, n2));
    }

    public static void addText(Project project, Object object, String string) throws BuildException {
        if (string == null) {
            return;
        }
        if (object instanceof TypeAdapter) {
            object = ((TypeAdapter)object).getProxy();
        }
        IntrospectionHelper.getHelper(project, object.getClass()).addText(project, object, string);
    }

    public static void storeChild(Project project, Object object, Object object2, String string) {
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object.getClass());
        introspectionHelper.storeElement(project, object, object2, string);
    }

    public static String replaceProperties(Project project, String string) throws BuildException {
        return project.replaceProperties(string);
    }

    public static String replaceProperties(Project project, String string, Hashtable hashtable) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(project);
        return propertyHelper.replaceProperties(null, string, hashtable);
    }

    public static void parsePropertyString(String string, Vector vector, Vector vector2) throws BuildException {
        PropertyHelper.parsePropertyStringDefault(string, vector, vector2);
    }

    public static String genComponentName(String string, String string2) {
        if (string == null || string.equals("") || string.equals(ANT_CORE_URI)) {
            return string2;
        }
        return string + ":" + string2;
    }

    public static String extractUriFromComponentName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String extractNameFromComponentName(String string) {
        int n = string.lastIndexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static BuildException addLocationToBuildException(BuildException buildException, Location location) {
        if (buildException.getLocation() == null || buildException.getMessage() == null) {
            return buildException;
        }
        String string = "The following error occurred while executing this line:" + System.getProperty("line.separator") + buildException.getLocation().toString() + buildException.getMessage();
        if (location == null) {
            return new BuildException(string, buildException);
        }
        return new BuildException(string, buildException, location);
    }
}

