/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.ProxySetup;

public class Main
implements AntMain {
    private static final Set LAUNCH_COMMANDS = new HashSet();
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out;
    private static PrintStream err;
    private Vector targets = new Vector();
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(1);
    private Vector propertyFiles = new Vector(1);
    private boolean allowInput = true;
    private boolean keepGoingMode = false;
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed;
    private Integer threadPriority = null;
    private boolean proxy = false;
    private static String antVersion;

    private static void printMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null) {
            System.err.println(string);
        }
    }

    public static void start(String[] stringArray, Properties properties, ClassLoader classLoader) {
        Main main = new Main();
        main.startAnt(stringArray, properties, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAnt(String[] stringArray, Properties properties, ClassLoader classLoader) {
        try {
            Diagnostics.validateVersion();
            this.processArgs(stringArray);
        }
        catch (Throwable throwable) {
            Main.handleLogfile();
            Main.printMessage(throwable);
            this.exit(1);
            return;
        }
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this.definedProps.put(string, string2);
            }
        }
        int n = 1;
        try {
            try {
                this.runBuild(classLoader);
                n = 0;
            }
            catch (ExitStatusException exitStatusException) {
                n = exitStatusException.getStatus();
                if (n != 0) {
                    throw exitStatusException;
                }
            }
        }
        catch (BuildException buildException) {
            if (err != System.err) {
                Main.printMessage(buildException);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Main.printMessage(throwable);
        }
        finally {
            Main.handleLogfile();
        }
        this.exit(n);
    }

    protected void exit(int n) {
        System.exit(n);
    }

    private static void handleLogfile() {
        if (isLogFileUsed) {
            FileUtils.close(out);
            FileUtils.close(err);
        }
    }

    public static void main(String[] stringArray) {
        Main.start(stringArray, null, null);
    }

    public Main() {
    }

    protected Main(String[] stringArray) throws BuildException {
        this.processArgs(stringArray);
    }

    private void processArgs(String[] stringArray) {
        String string = null;
        PrintStream printStream = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string2 = stringArray[i];
            if (string2.equals("-help") || string2.equals("-h")) {
                Main.printUsage();
                return;
            }
            if (string2.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (string2.equals("-diagnostics")) {
                Diagnostics.doReport(System.out);
                return;
            }
            if (string2.equals("-quiet") || string2.equals("-q")) {
                this.msgOutputLevel = 1;
                continue;
            }
            if (string2.equals("-verbose") || string2.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
                continue;
            }
            if (string2.equals("-debug") || string2.equals("-d")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
                continue;
            }
            if (string2.equals("-noinput")) {
                this.allowInput = false;
                continue;
            }
            if (string2.equals("-logfile") || string2.equals("-l")) {
                try {
                    object = new File(stringArray[i + 1]);
                    ++i;
                    printStream = new PrintStream(new FileOutputStream((File)object));
                    isLogFileUsed = true;
                    continue;
                }
                catch (IOException iOException) {
                    String string3 = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    throw new BuildException(string3);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    String string4 = "You must specify a log file when using the -log argument";
                    throw new BuildException(string4);
                }
            }
            if (string2.equals("-buildfile") || string2.equals("-file") || string2.equals("-f")) {
                i = this.handleArgBuildFile(stringArray, i);
                continue;
            }
            if (string2.equals("-listener")) {
                i = this.handleArgListener(stringArray, i);
                continue;
            }
            if (string2.startsWith("-D")) {
                i = this.handleArgDefine(stringArray, i);
                continue;
            }
            if (string2.equals("-logger")) {
                i = this.handleArgLogger(stringArray, i);
                continue;
            }
            if (string2.equals("-inputhandler")) {
                i = this.handleArgInputHandler(stringArray, i);
                continue;
            }
            if (string2.equals("-emacs") || string2.equals("-e")) {
                this.emacsMode = true;
                continue;
            }
            if (string2.equals("-projecthelp") || string2.equals("-p")) {
                this.projectHelp = true;
                continue;
            }
            if (string2.equals("-find") || string2.equals("-s")) {
                if (i < stringArray.length - 1) {
                    string = stringArray[++i];
                    continue;
                }
                string = DEFAULT_BUILD_FILENAME;
                continue;
            }
            if (string2.startsWith("-propertyfile")) {
                i = this.handleArgPropertyFile(stringArray, i);
                continue;
            }
            if (string2.equals("-k") || string2.equals("-keep-going")) {
                this.keepGoingMode = true;
                continue;
            }
            if (string2.equals("-nice")) {
                i = this.handleArgNice(stringArray, i);
                continue;
            }
            if (LAUNCH_COMMANDS.contains(string2)) {
                object = "Ant's Main method is being handed an option " + string2 + " that is only for the launcher class." + "\nThis can be caused by a version mismatch between " + "the ant script/.bat file and Ant itself.";
                throw new BuildException((String)object);
            }
            if (string2.equals("-autoproxy")) {
                this.proxy = true;
                continue;
            }
            if (string2.startsWith("-")) {
                object = "Unknown argument: " + string2;
                System.err.println((String)object);
                Main.printUsage();
                throw new BuildException("");
            }
            this.targets.addElement(string2);
        }
        if (this.buildFile == null) {
            this.buildFile = string != null ? this.findBuildFile(System.getProperty("user.dir"), string) : new File(DEFAULT_BUILD_FILENAME);
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        this.loadPropertyFiles();
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        if (printStream != null) {
            out = printStream;
            err = printStream;
            System.setOut(out);
            System.setErr(err);
        }
        this.readyToRun = true;
    }

    private int handleArgBuildFile(String[] stringArray, int n) {
        try {
            this.buildFile = new File(stringArray[++n].replace('/', File.separatorChar));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BuildException("You must specify a buildfile when using the -buildfile argument");
        }
        return n;
    }

    private int handleArgListener(String[] stringArray, int n) {
        try {
            this.listeners.addElement(stringArray[n + 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "You must specify a classname when using the -listener argument";
            throw new BuildException(string);
        }
        return ++n;
    }

    private int handleArgDefine(String[] stringArray, int n) {
        String string = stringArray[n];
        String string2 = string.substring(2, string.length());
        String string3 = null;
        int n2 = string2.indexOf("=");
        if (n2 > 0) {
            string3 = string2.substring(n2 + 1);
            string2 = string2.substring(0, n2);
        } else if (n < stringArray.length - 1) {
            string3 = stringArray[++n];
        } else {
            throw new BuildException("Missing value for property " + string2);
        }
        this.definedProps.put(string2, string3);
        return n;
    }

    private int handleArgLogger(String[] stringArray, int n) {
        if (this.loggerClassname != null) {
            throw new BuildException("Only one logger class may be specified.");
        }
        try {
            this.loggerClassname = stringArray[++n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BuildException("You must specify a classname when using the -logger argument");
        }
        return n;
    }

    private int handleArgInputHandler(String[] stringArray, int n) {
        if (this.inputHandlerClassname != null) {
            throw new BuildException("Only one input handler class may be specified.");
        }
        try {
            this.inputHandlerClassname = stringArray[++n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BuildException("You must specify a classname when using the -inputhandler argument");
        }
        return n;
    }

    private int handleArgPropertyFile(String[] stringArray, int n) {
        try {
            this.propertyFiles.addElement(stringArray[++n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "You must specify a property filename when using the -propertyfile argument";
            throw new BuildException(string);
        }
        return n;
    }

    private int handleArgNice(String[] stringArray, int n) {
        try {
            this.threadPriority = Integer.decode(stringArray[++n]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BuildException("You must supply a niceness value (1-10) after the -nice option");
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Unrecognized niceness value: " + stringArray[n]);
        }
        if (this.threadPriority < 1 || this.threadPriority > 10) {
            throw new BuildException("Niceness value is out of the range 1-10");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertyFiles() {
        for (int i = 0; i < this.propertyFiles.size(); ++i) {
            String string = (String)this.propertyFiles.elementAt(i);
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                try {
                    System.out.println("Could not load property file " + string + ": " + iOException.getMessage());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (this.definedProps.getProperty(string2) != null) continue;
                this.definedProps.put(string2, properties.getProperty(string2));
            }
        }
    }

    private File getParentFile(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + file2.getAbsolutePath());
        }
        return file2;
    }

    private File findBuildFile(String string, String string2) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + string2 + " ...");
        }
        File file = new File(new File(string).getAbsolutePath());
        File file2 = new File(file, string2);
        while (!file2.exists()) {
            if ((file = this.getParentFile(file)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file2 = new File(file, string2);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader classLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(classLoader);
        Throwable throwable = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream printStream = System.err;
            PrintStream printStream2 = System.out;
            InputStream inputStream = System.in;
            SecurityManager securityManager = null;
            securityManager = System.getSecurityManager();
            try {
                Object object;
                if (this.allowInput) {
                    project.setDefaultInputStream(System.in);
                }
                System.setIn(new DemuxInputStream(project));
                System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                if (!this.projectHelp) {
                    project.fireBuildStarted();
                }
                if (this.threadPriority != null) {
                    try {
                        project.log("Setting Ant's thread priority to " + this.threadPriority, 3);
                        Thread.currentThread().setPriority(this.threadPriority);
                    }
                    catch (SecurityException securityException) {
                        project.log("A security manager refused to set the -nice value");
                    }
                }
                project.init();
                Enumeration<Object> enumeration = this.definedProps.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    String string = (String)this.definedProps.get(object);
                    project.setUserProperty((String)object, string);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                project.setKeepGoingMode(this.keepGoingMode);
                if (this.proxy) {
                    object = new ProxySetup(project);
                    ((ProxySetup)object).enableProxies();
                }
                ProjectHelper.configureProject(project, this.buildFile);
                if (this.projectHelp) {
                    Main.printDescription(project);
                    Main.printTargets(project, this.msgOutputLevel > 2);
                    return;
                }
                if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                if (securityManager != null) {
                    System.setSecurityManager(securityManager);
                }
                System.setOut(printStream2);
                System.setErr(printStream);
                System.setIn(inputStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            throwable = error;
            throw error;
        }
        finally {
            if (!this.projectHelp) {
                project.fireBuildFinished(throwable);
            } else if (throwable != null) {
                project.log(throwable.toString(), 0);
            }
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        for (int i = 0; i < this.listeners.size(); ++i) {
            String string = (String)this.listeners.elementAt(i);
            BuildListener buildListener = (BuildListener)ClasspathUtils.newInstance(string, Main.class.getClassLoader(), BuildListener.class);
            project.setProjectReference(buildListener);
            project.addBuildListener(buildListener);
        }
    }

    private void addInputHandler(Project project) throws BuildException {
        InputHandler inputHandler = null;
        if (this.inputHandlerClassname == null) {
            inputHandler = new DefaultInputHandler();
        } else {
            inputHandler = (InputHandler)ClasspathUtils.newInstance(this.inputHandlerClassname, Main.class.getClassLoader(), InputHandler.class);
            project.setProjectReference(inputHandler);
        }
        project.setInputHandler(inputHandler);
    }

    private BuildLogger createLogger() {
        BuildLogger buildLogger = null;
        if (this.loggerClassname != null) {
            try {
                buildLogger = (BuildLogger)ClasspathUtils.newInstance(this.loggerClassname, Main.class.getClassLoader(), BuildLogger.class);
            }
            catch (BuildException buildException) {
                System.err.println("The specified logger class " + this.loggerClassname + " could not be used because " + buildException.getMessage());
                throw new RuntimeException();
            }
        } else {
            buildLogger = new DefaultLogger();
        }
        buildLogger.setMessageOutputLevel(this.msgOutputLevel);
        buildLogger.setOutputPrintStream(out);
        buildLogger.setErrorPrintStream(err);
        buildLogger.setEmacsMode(this.emacsMode);
        return buildLogger;
    }

    private static void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ant [options] [target [target2 [target3] ...]]" + string);
        stringBuffer.append("Options: " + string);
        stringBuffer.append("  -help, -h              print this message" + string);
        stringBuffer.append("  -projecthelp, -p       print project help information" + string);
        stringBuffer.append("  -version               print the version information and exit" + string);
        stringBuffer.append("  -diagnostics           print information that might be helpful to" + string);
        stringBuffer.append("                         diagnose or report problems." + string);
        stringBuffer.append("  -quiet, -q             be extra quiet" + string);
        stringBuffer.append("  -verbose, -v           be extra verbose" + string);
        stringBuffer.append("  -debug, -d             print debugging information" + string);
        stringBuffer.append("  -emacs, -e             produce logging information without adornments" + string);
        stringBuffer.append("  -lib <path>            specifies a path to search for jars and classes" + string);
        stringBuffer.append("  -logfile <file>        use given file for log" + string);
        stringBuffer.append("    -l     <file>                ''" + string);
        stringBuffer.append("  -logger <classname>    the class which is to perform logging" + string);
        stringBuffer.append("  -listener <classname>  add an instance of class as a project listener" + string);
        stringBuffer.append("  -noinput               do not allow interactive input" + string);
        stringBuffer.append("  -buildfile <file>      use given buildfile" + string);
        stringBuffer.append("    -file    <file>              ''" + string);
        stringBuffer.append("    -f       <file>              ''" + string);
        stringBuffer.append("  -D<property>=<value>   use value for given property" + string);
        stringBuffer.append("  -keep-going, -k        execute all targets that do not depend" + string);
        stringBuffer.append("                         on failed target(s)" + string);
        stringBuffer.append("  -propertyfile <name>   load all properties from file with -D" + string);
        stringBuffer.append("                         properties taking precedence" + string);
        stringBuffer.append("  -inputhandler <class>  the class which will handle input requests" + string);
        stringBuffer.append("  -find <file>           (s)earch for buildfile towards the root of" + string);
        stringBuffer.append("    -s  <file>           the filesystem and use it" + string);
        stringBuffer.append("  -nice  number          A niceness value for the main thread:" + string + "                         1 (lowest) to 10 (highest); 5 is the default" + string);
        stringBuffer.append("  -nouserlib             Run ant without using the jar files from" + string + "                         ${user.home}/.ant/lib" + string);
        stringBuffer.append("  -noclasspath           Run ant without using CLASSPATH" + string);
        stringBuffer.append("  -autoproxy             Java1.5+: use the OS proxy settings" + string);
        stringBuffer.append("  -main <class>          override Ant's normal entry point");
        System.out.println(stringBuffer.toString());
    }

    private static void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = Main.class.getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Apache Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static Map removeDuplicateTargets(Map map) {
        HashMap<Location, Target> hashMap = new HashMap<Location, Target>();
        for (Map.Entry object : map.entrySet()) {
            Object object2 = (String)object.getKey();
            Target target = (Target)object.getValue();
            Target target2 = (Target)hashMap.get(target.getLocation());
            if (target2 != null && target2.getName().length() <= ((String)object2).length()) continue;
            hashMap.put(target.getLocation(), target);
        }
        HashMap hashMap2 = new HashMap();
        for (Object object2 : hashMap.values()) {
            hashMap2.put(((Target)object2).getName(), object2);
        }
        return hashMap2;
    }

    private static void printTargets(Project project, boolean bl) {
        int n = 0;
        Map map = Main.removeDuplicateTargets(project.getTargets());
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Object object = map.values().iterator();
        while (object.hasNext()) {
            int n2;
            Target target = (Target)object.next();
            String string = target.getName();
            if (string.equals("")) continue;
            String string2 = target.getDescription();
            if (string2 == null) {
                n2 = Main.findTargetPosition(vector3, string);
                vector3.insertElementAt(string, n2);
                continue;
            }
            n2 = Main.findTargetPosition(vector, string);
            vector.insertElementAt(string, n2);
            vector2.insertElementAt(string2, n2);
            if (string.length() <= n) continue;
            n = string.length();
        }
        Main.printTargets(project, vector, vector2, "Main targets:", n);
        if (vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            Main.printTargets(project, vector3, null, "Other targets:", 0);
        }
        if ((object = project.getDefaultTarget()) != null && !"".equals(object)) {
            project.log("Default target: " + (String)object);
        }
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        for (int i = 0; i < vector.size() && n == vector.size(); ++i) {
            if (string.compareTo((String)vector.elementAt(i)) >= 0) continue;
            n = i;
        }
        return n;
    }

    private static void printTargets(Project project, Vector vector, Vector vector2, String string, int n) {
        String string2 = System.getProperty("line.separator");
        String string3 = "    ";
        while (string3.length() <= n) {
            string3 = string3 + string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + string2);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(i));
            if (vector2 != null) {
                stringBuffer.append(string3.substring(0, n - ((String)vector.elementAt(i)).length() + 2));
                stringBuffer.append(vector2.elementAt(i));
            }
            stringBuffer.append(string2);
        }
        project.log(stringBuffer.toString(), 1);
    }

    static {
        LAUNCH_COMMANDS.add("-lib");
        LAUNCH_COMMANDS.add("-cp");
        LAUNCH_COMMANDS.add("-noclasspath");
        LAUNCH_COMMANDS.add("--noclasspath");
        LAUNCH_COMMANDS.add("-nouserlib");
        LAUNCH_COMMANDS.add("-main");
        out = System.out;
        err = System.err;
        isLogFileUsed = false;
        antVersion = null;
    }
}

