/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.launch.Launcher;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.xml.sax.XMLReader;

public final class Diagnostics {
    private static final int BIG_DRIFT_LIMIT = 10000;
    private static final int TEST_FILE_SIZE = 32;
    private static final int KILOBYTE = 1024;
    private static final int SECONDS_PER_MILLISECOND = 1000;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final String TEST_CLASS = "org.apache.tools.ant.taskdefs.optional.Test";
    protected static final String ERROR_PROPERTY_ACCESS_BLOCKED = "Access to this property blocked by a security manager";

    private Diagnostics() {
    }

    public static boolean isOptionalAvailable() {
        try {
            Class.forName(TEST_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static void validateVersion() throws BuildException {
        try {
            Class<?> clazz = Class.forName(TEST_CLASS);
            String string = Diagnostics.getImplementationVersion(Main.class);
            String string2 = Diagnostics.getImplementationVersion(clazz);
            if (string != null && !string.equals(string2)) {
                throw new BuildException("Invalid implementation version between Ant core and Ant optional tasks.\n core    : " + string + "\n" + " optional: " + string2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Diagnostics.ignoreThrowable(classNotFoundException);
        }
    }

    public static File[] listLibraries() {
        String string = System.getProperty("ant.home");
        if (string == null) {
            return null;
        }
        File file = new File(string, "lib");
        return Diagnostics.listJarFiles(file);
    }

    private static File[] listJarFiles(File file) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        return fileArray;
    }

    public static void main(String[] stringArray) {
        Diagnostics.doReport(System.out);
    }

    private static String getImplementationVersion(Class clazz) {
        Package package_ = clazz.getPackage();
        return package_.getImplementationVersion();
    }

    private static String getXmlParserName() {
        SAXParser sAXParser = Diagnostics.getSAXParser();
        if (sAXParser == null) {
            return "Could not create an XML Parser";
        }
        String string = sAXParser.getClass().getName();
        return string;
    }

    private static SAXParser getSAXParser() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (sAXParserFactory == null) {
            return null;
        }
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            Diagnostics.ignoreThrowable(exception);
        }
        return sAXParser;
    }

    private static String getXMLParserLocation() {
        SAXParser sAXParser = Diagnostics.getSAXParser();
        if (sAXParser == null) {
            return null;
        }
        String string = Diagnostics.getClassLocation(sAXParser.getClass());
        return string;
    }

    private static String getNamespaceParserName() {
        try {
            XMLReader xMLReader = JAXPUtils.getNamespaceXMLReader();
            return xMLReader.getClass().getName();
        }
        catch (BuildException buildException) {
            Diagnostics.ignoreThrowable(buildException);
            return null;
        }
    }

    private static String getNamespaceParserLocation() {
        try {
            XMLReader xMLReader = JAXPUtils.getNamespaceXMLReader();
            return Diagnostics.getClassLocation(xMLReader.getClass());
        }
        catch (BuildException buildException) {
            Diagnostics.ignoreThrowable(buildException);
            return null;
        }
    }

    private static void ignoreThrowable(Throwable throwable) {
    }

    private static String getClassLocation(Class clazz) {
        File file = LoaderUtils.getClassSource(clazz);
        return file == null ? null : file.getAbsolutePath();
    }

    public static void doReport(PrintStream printStream) {
        printStream.println("------- Ant diagnostics report -------");
        printStream.println(Main.getAntVersion());
        Diagnostics.header(printStream, "Implementation Version");
        printStream.println("core tasks     : " + Diagnostics.getImplementationVersion(Main.class));
        Class<?> clazz = null;
        try {
            clazz = Class.forName(TEST_CLASS);
            printStream.println("optional tasks : " + Diagnostics.getImplementationVersion(clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Diagnostics.ignoreThrowable(classNotFoundException);
            printStream.println("optional tasks : not available");
        }
        Diagnostics.header(printStream, "ANT PROPERTIES");
        Diagnostics.doReportAntProperties(printStream);
        Diagnostics.header(printStream, "ANT_HOME/lib jar listing");
        Diagnostics.doReportAntHomeLibraries(printStream);
        Diagnostics.header(printStream, "USER_HOME/.ant/lib jar listing");
        Diagnostics.doReportUserHomeLibraries(printStream);
        Diagnostics.header(printStream, "Tasks availability");
        Diagnostics.doReportTasksAvailability(printStream);
        Diagnostics.header(printStream, "org.apache.env.Which diagnostics");
        Diagnostics.doReportWhich(printStream);
        Diagnostics.header(printStream, "XML Parser information");
        Diagnostics.doReportParserInfo(printStream);
        Diagnostics.header(printStream, "System properties");
        Diagnostics.doReportSystemProperties(printStream);
        Diagnostics.header(printStream, "Temp dir");
        Diagnostics.doReportTempDir(printStream);
        Diagnostics.header(printStream, "Locale information");
        Diagnostics.doReportLocale(printStream);
        Diagnostics.header(printStream, "Proxy information");
        Diagnostics.doReportProxy(printStream);
        printStream.println();
    }

    private static void header(PrintStream printStream, String string) {
        printStream.println();
        printStream.println("-------------------------------------------");
        printStream.print(" ");
        printStream.println(string);
        printStream.println("-------------------------------------------");
    }

    private static void doReportSystemProperties(PrintStream printStream) {
        Properties properties = null;
        try {
            properties = System.getProperties();
        }
        catch (SecurityException securityException) {
            Diagnostics.ignoreThrowable(securityException);
            printStream.println("Access to System.getProperties() blocked by a security manager");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = Diagnostics.getProperty(string);
            printStream.println(string + " : " + string2);
        }
    }

    private static String getProperty(String string) {
        String string2;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = ERROR_PROPERTY_ACCESS_BLOCKED;
        }
        return string2;
    }

    private static void doReportAntProperties(PrintStream printStream) {
        Project project = new Project();
        project.initProperties();
        printStream.println("ant.version: " + project.getProperty("ant.version"));
        printStream.println("ant.java.version: " + project.getProperty("ant.java.version"));
        printStream.println("ant.core.lib: " + project.getProperty("ant.core.lib"));
        printStream.println("ant.home: " + project.getProperty("ant.home"));
    }

    private static void doReportAntHomeLibraries(PrintStream printStream) {
        printStream.println("ant.home: " + System.getProperty("ant.home"));
        File[] fileArray = Diagnostics.listLibraries();
        Diagnostics.printLibraries(fileArray, printStream);
    }

    private static void doReportUserHomeLibraries(PrintStream printStream) {
        String string = System.getProperty("user.home");
        printStream.println("user.home: " + string);
        File file = new File(string, Launcher.USER_LIBDIR);
        File[] fileArray = Diagnostics.listJarFiles(file);
        Diagnostics.printLibraries(fileArray, printStream);
    }

    private static void printLibraries(File[] fileArray, PrintStream printStream) {
        if (fileArray == null) {
            printStream.println("No such directory.");
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            printStream.println(fileArray[i].getName() + " (" + fileArray[i].length() + " bytes)");
        }
    }

    private static void doReportWhich(PrintStream printStream) {
        Throwable throwable = null;
        try {
            Class<?> clazz = Class.forName("org.apache.env.Which");
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(null, new Object[]{new String[0]});
        }
        catch (ClassNotFoundException classNotFoundException) {
            printStream.println("Not available.");
            printStream.println("Download it at http://xml.apache.org/commons/");
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException() == null ? invocationTargetException : invocationTargetException.getTargetException();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            printStream.println("Error while running org.apache.env.Which");
            throwable.printStackTrace();
        }
    }

    private static void doReportTasksAvailability(PrintStream printStream) {
        InputStream inputStream = Main.class.getResourceAsStream("/org/apache/tools/ant/taskdefs/defaults.properties");
        if (inputStream == null) {
            printStream.println("None available");
        } else {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    try {
                        Class.forName(string2);
                        properties.remove(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        printStream.println(string + " : Not Available " + "(the implementation class is not present)");
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        String string3 = noClassDefFoundError.getMessage().replace('/', '.');
                        printStream.println(string + " : Missing dependency " + string3);
                    }
                    catch (LinkageError linkageError) {
                        printStream.println(string + " : Initialization error");
                    }
                }
                if (properties.size() == 0) {
                    printStream.println("All defined tasks are available");
                } else {
                    printStream.println("A task being missing/unavailable should only matter if you are trying to use it");
                }
            }
            catch (IOException iOException) {
                printStream.println(iOException.getMessage());
            }
        }
    }

    private static void doReportParserInfo(PrintStream printStream) {
        String string = Diagnostics.getXmlParserName();
        String string2 = Diagnostics.getXMLParserLocation();
        Diagnostics.printParserInfo(printStream, "XML Parser", string, string2);
        Diagnostics.printParserInfo(printStream, "Namespace-aware parser", Diagnostics.getNamespaceParserName(), Diagnostics.getNamespaceParserLocation());
    }

    private static void printParserInfo(PrintStream printStream, String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "unknown";
        }
        if (string3 == null) {
            string3 = "unknown";
        }
        printStream.println(string + " : " + string2);
        printStream.println(string + " Location: " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReportTempDir(PrintStream printStream) {
        FileOutputStream fileOutputStream;
        File file;
        block10: {
            String string = System.getProperty("java.io.tmpdir");
            if (string == null) {
                printStream.println("Warning: java.io.tmpdir is undefined");
                return;
            }
            printStream.println("Temp dir is " + string);
            File file2 = new File(string);
            if (!file2.exists()) {
                printStream.println("Warning, java.io.tmpdir directory does not exist: " + string);
                return;
            }
            long l = System.currentTimeMillis();
            file = null;
            fileOutputStream = null;
            try {
                file = File.createTempFile("diag", "txt", file2);
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                for (int i = 0; i < 32; ++i) {
                    fileOutputStream.write(byArray);
                }
                fileOutputStream.close();
                fileOutputStream = null;
                long l2 = file.lastModified();
                file.delete();
                printStream.println("Temp dir is writeable");
                long l3 = l2 - l;
                printStream.println("Temp dir alignment with system clock is " + l3 + " ms");
                if (Math.abs(l3) <= 10000L) break block10;
                printStream.println("Warning: big clock drift -maybe a network filesystem");
            }
            catch (IOException iOException) {
                try {
                    Diagnostics.ignoreThrowable(iOException);
                    printStream.println("Failed to create a temporary file in the temp dir " + string);
                    printStream.println("File  " + file + " could not be created/written to");
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileOutputStream);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                    throw throwable;
                }
                FileUtils.close(fileOutputStream);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        }
        FileUtils.close(fileOutputStream);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private static void doReportLocale(PrintStream printStream) {
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = calendar.getTimeZone();
        printStream.println("Timezone " + timeZone.getDisplayName() + " offset=" + timeZone.getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14)));
    }

    private static void printProperty(PrintStream printStream, String string) {
        String string2 = Diagnostics.getProperty(string);
        if (string2 != null) {
            printStream.print(string);
            printStream.print(" = ");
            printStream.print('\"');
            printStream.print(string2);
            printStream.println('\"');
        }
    }

    private static void doReportProxy(PrintStream printStream) {
        Diagnostics.printProperty(printStream, "http.proxyHost");
        Diagnostics.printProperty(printStream, "http.proxyPort");
        Diagnostics.printProperty(printStream, "http.proxyUser");
        Diagnostics.printProperty(printStream, "http.proxyPassword");
        Diagnostics.printProperty(printStream, "http.nonProxyHosts");
        Diagnostics.printProperty(printStream, "https.proxyHost");
        Diagnostics.printProperty(printStream, "https.proxyPort");
        Diagnostics.printProperty(printStream, "https.nonProxyHosts");
        Diagnostics.printProperty(printStream, "ftp.proxyHost");
        Diagnostics.printProperty(printStream, "ftp.proxyPort");
        Diagnostics.printProperty(printStream, "ftp.nonProxyHosts");
        Diagnostics.printProperty(printStream, "socksProxyHost");
        Diagnostics.printProperty(printStream, "socksProxyPort");
        Diagnostics.printProperty(printStream, "java.net.socks.username");
        Diagnostics.printProperty(printStream, "java.net.socks.password");
        if (JavaEnvUtils.getJavaVersionNumber() < 15) {
            return;
        }
        Diagnostics.printProperty(printStream, "java.net.useSystemProxies");
        try {
            Class<?> clazz = Class.forName("org.apache.tools.ant.util.java15.ProxyDiagnostics");
            Object obj = clazz.newInstance();
            printStream.println("Java1.5+ proxy settings:");
            printStream.println(obj.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

