/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class DefaultLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    protected boolean emacsMode = false;

    @Override
    public void setMessageOutputLevel(int n) {
        this.msgOutputLevel = n;
    }

    @Override
    public void setOutputPrintStream(PrintStream printStream) {
        this.out = new PrintStream(printStream, true);
    }

    @Override
    public void setErrorPrintStream(PrintStream printStream) {
        this.err = new PrintStream(printStream, true);
    }

    @Override
    public void setEmacsMode(boolean bl) {
        this.emacsMode = bl;
    }

    @Override
    public void buildStarted(BuildEvent buildEvent) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void buildFinished(BuildEvent buildEvent) {
        Object object;
        Object object2 = buildEvent.getException();
        StringBuffer stringBuffer = new StringBuffer();
        if (object2 == null) {
            stringBuffer.append(StringUtils.LINE_SEP);
            stringBuffer.append(this.getBuildSuccessfulMessage());
        } else {
            stringBuffer.append(StringUtils.LINE_SEP);
            stringBuffer.append(this.getBuildFailedMessage());
            stringBuffer.append(StringUtils.LINE_SEP);
            while (object2 instanceof BuildException && (object = ((BuildException)object2).getCause()) != null && ((Throwable)object).toString().equals(((Throwable)object2).getMessage())) {
                object2 = object;
            }
            if (3 <= this.msgOutputLevel || !(object2 instanceof BuildException)) {
                stringBuffer.append(StringUtils.getStackTrace((Throwable)object2));
            } else {
                stringBuffer.append(((Throwable)object2).toString()).append(lSep);
            }
        }
        stringBuffer.append(StringUtils.LINE_SEP);
        stringBuffer.append("Total time: ");
        stringBuffer.append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
        object = stringBuffer.toString();
        if (object2 == null) {
            this.printMessage((String)object, this.out, 3);
        } else {
            this.printMessage((String)object, this.err, 0);
        }
        this.log((String)object);
    }

    protected String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    @Override
    public void targetStarted(BuildEvent buildEvent) {
        if (2 <= this.msgOutputLevel && !buildEvent.getTarget().getName().equals("")) {
            String string = StringUtils.LINE_SEP + buildEvent.getTarget().getName() + ":";
            this.printMessage(string, this.out, buildEvent.getPriority());
            this.log(string);
        }
    }

    @Override
    public void targetFinished(BuildEvent buildEvent) {
    }

    @Override
    public void taskStarted(BuildEvent buildEvent) {
    }

    @Override
    public void taskFinished(BuildEvent buildEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void messageLogged(BuildEvent var1_1) {
        var2_2 = var1_1.getPriority();
        if (var2_2 <= this.msgOutputLevel) {
            block17: {
                var3_3 = new StringBuffer();
                if (var1_1.getTask() != null && !this.emacsMode) {
                    var4_4 = var1_1.getTask().getTaskName();
                    var5_5 = "[" + (String)var4_4 + "] ";
                    var6_6 = 12 - var5_5.length();
                    var7_7 = new StringBuffer();
                    for (var8_8 = 0; var8_8 < var6_6; ++var8_8) {
                        var7_7.append(" ");
                    }
                    var7_7.append(var5_5);
                    var5_5 = var7_7.toString();
                    var8_9 = null;
                    try {
                        var8_9 = new BufferedReader(new StringReader(var1_1.getMessage()));
                        var9_10 = var8_9.readLine();
                        var10_12 = true;
                        do {
                            if (var10_12) {
                                if (var9_10 == null) {
                                    var3_3.append(var5_5);
                                    break;
                                }
                            } else {
                                var3_3.append(StringUtils.LINE_SEP);
                            }
                            var10_12 = false;
                            var3_3.append(var5_5).append(var9_10);
                        } while ((var9_10 = var8_9.readLine()) != null);
                        ** if (var8_9 == null) goto lbl-1000
                    }
                    catch (IOException var9_11) {
                        try {
                            var3_3.append(var5_5).append(var1_1.getMessage());
                            ** if (var8_9 == null) goto lbl-1000
                        }
                        catch (Throwable var11_13) {
                            if (var8_9 != null) {
                                FileUtils.close(var8_9);
                            }
                            throw var11_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            FileUtils.close(var8_9);
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block17;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileUtils.close(var8_9);
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                    }
                }
                var3_3.append(var1_1.getMessage());
            }
            var4_4 = var1_1.getException();
            if (4 <= this.msgOutputLevel && var4_4 != null) {
                var3_3.append(StringUtils.getStackTrace((Throwable)var4_4));
            }
            var5_5 = var3_3.toString();
            if (var2_2 != 0) {
                this.printMessage(var5_5, this.out, var2_2);
            } else {
                this.printMessage(var5_5, this.err, var2_2);
            }
            this.log(var5_5);
        }
    }

    protected static String formatTime(long l) {
        return DateUtils.formatElapsedTime(l);
    }

    protected void printMessage(String string, PrintStream printStream, int n) {
        printStream.println(string);
    }

    protected void log(String string) {
    }

    protected String getTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        String string = dateFormat.format(date);
        return string;
    }

    protected String extractProjectName(BuildEvent buildEvent) {
        Project project = buildEvent.getProject();
        return project != null ? project.getName() : null;
    }
}

