/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.TypeAdapter;

public class AntTypeDefinition {
    private String name;
    private Class clazz;
    private Class adapterClass;
    private Class adaptToClass;
    private String className;
    private ClassLoader classLoader;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setClass(Class clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            return;
        }
        this.classLoader = this.classLoader == null ? clazz.getClassLoader() : this.classLoader;
        this.className = this.className == null ? clazz.getName() : this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setAdapterClass(Class clazz) {
        this.adapterClass = clazz;
    }

    public void setAdaptToClass(Class clazz) {
        this.adaptToClass = clazz;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class getExposedClass(Project project) {
        Class clazz;
        if (this.adaptToClass != null && ((clazz = this.getTypeClass(project)) == null || this.adaptToClass.isAssignableFrom(clazz))) {
            return clazz;
        }
        return this.adapterClass == null ? this.getTypeClass(project) : this.adapterClass;
    }

    public Class getTypeClass(Project project) {
        try {
            return this.innerGetTypeClass();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            project.log("Could not load a dependent class (" + noClassDefFoundError.getMessage() + ") for type " + this.name, 4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            project.log("Could not load class (" + this.className + ") for type " + this.name, 4);
        }
        return null;
    }

    public Class innerGetTypeClass() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        this.clazz = this.classLoader == null ? Class.forName(this.className) : this.classLoader.loadClass(this.className);
        return this.clazz;
    }

    public Object create(Project project) {
        return this.icreate(project);
    }

    private Object icreate(Project project) {
        Class clazz = this.getTypeClass(project);
        if (clazz == null) {
            return null;
        }
        Object object = this.createAndSet(project, clazz);
        if (object == null || this.adapterClass == null) {
            return object;
        }
        if (this.adaptToClass != null && this.adaptToClass.isAssignableFrom(object.getClass())) {
            return object;
        }
        TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
        if (typeAdapter == null) {
            return null;
        }
        typeAdapter.setProxy(object);
        return typeAdapter;
    }

    public void checkClass(Project project) {
        if (this.clazz == null) {
            this.clazz = this.getTypeClass(project);
            if (this.clazz == null) {
                throw new BuildException("Unable to create class for " + this.getName());
            }
        }
        if (!(this.adapterClass == null || this.adaptToClass != null && this.adaptToClass.isAssignableFrom(this.clazz))) {
            TypeAdapter typeAdapter = (TypeAdapter)this.createAndSet(project, this.adapterClass);
            if (typeAdapter == null) {
                throw new BuildException("Unable to create adapter object");
            }
            typeAdapter.checkProxyClass(this.clazz);
        }
    }

    private Object createAndSet(Project project, Class clazz) {
        try {
            Object object = this.innerCreateAndSet(clazz, project);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = "Type " + this.name + ": A class needed by class " + clazz + " cannot be found: " + noClassDefFoundError.getMessage();
            throw new BuildException(string, noClassDefFoundError);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BuildException("Could not create type " + this.name + " as the class " + clazz + " has no compatible constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException("Could not create type " + this.name + " as the class " + clazz + " is abstract");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException("Could not create type " + this.name + " as the constructor " + clazz + " is not accessible");
        }
        catch (Throwable throwable) {
            throw new BuildException("Could not create type " + this.name + " due to " + throwable, throwable);
        }
    }

    public Object innerCreateAndSet(Class clazz, Project project) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        Constructor constructor = null;
        boolean bl = false;
        try {
            constructor = clazz.getConstructor(new Class[0]);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            constructor = clazz.getConstructor(Project.class);
            bl = false;
        }
        if (bl) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = project;
        }
        Object t = constructor.newInstance(objectArray);
        project.setProjectReference(t);
        return t;
    }

    public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        return antTypeDefinition != null && antTypeDefinition.getClass() == this.getClass() && antTypeDefinition.getTypeClass(project).equals(this.getTypeClass(project)) && antTypeDefinition.getExposedClass(project).equals(this.getExposedClass(project)) && antTypeDefinition.adapterClass == this.adapterClass && antTypeDefinition.adaptToClass == this.adaptToClass;
    }

    public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
        ClassLoader classLoader;
        if (!(antTypeDefinition != null && this.getClass() == antTypeDefinition.getClass() && this.getClassName().equals(antTypeDefinition.getClassName()) && this.extractClassname(this.adapterClass).equals(this.extractClassname(antTypeDefinition.adapterClass)) && this.extractClassname(this.adaptToClass).equals(this.extractClassname(antTypeDefinition.adaptToClass)))) {
            return false;
        }
        ClassLoader classLoader2 = antTypeDefinition.getClassLoader();
        return classLoader2 == (classLoader = this.getClassLoader()) || classLoader2 instanceof AntClassLoader && classLoader instanceof AntClassLoader && ((AntClassLoader)classLoader2).getClasspath().equals(((AntClassLoader)classLoader).getClasspath());
    }

    private String extractClassname(Class clazz) {
        return clazz == null ? "<null>" : clazz.getClass().getName();
    }
}

