/*
 * Decompiled with CFR 0.152.
 */
package alma.archive;

import alma.ACS.CharacteristicComponentDesc;
import alma.ACS.CharacteristicComponentDescHelper;
import alma.ACS.ComponentStates;
import alma.ACS.ComponentStatesHelper;
import alma.ACS.NoSuchCharacteristic;
import alma.ACS.NoSuchCharacteristicHelper;
import alma.ACS.stringSeqHelper;
import alma.ACSBulkDataError.AVConnectErrorEx;
import alma.ACSBulkDataError.AVConnectErrorExHelper;
import alma.ACSBulkDataError.AVDisconnectErrorEx;
import alma.ACSBulkDataError.AVDisconnectErrorExHelper;
import alma.ACSBulkDataError.AVPaceDataErrorEx;
import alma.ACSBulkDataError.AVPaceDataErrorExHelper;
import alma.ACSBulkDataError.AVStartSendErrorEx;
import alma.ACSBulkDataError.AVStartSendErrorExHelper;
import alma.ACSBulkDataError.AVStopSendErrorEx;
import alma.ACSBulkDataError.AVStopSendErrorExHelper;
import alma.archive.ArchiveBulkSender;
import alma.archive.ArchiveBulkSenderHelper;
import alma.archive.ArchiveBulkSenderOperations;
import alma.bulkdata.BulkDataReceiver;
import alma.bulkdata.BulkDataReceiverHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CosPropertyService.PropertySet;
import org.omg.CosPropertyService.PropertySetHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class ArchiveBulkSenderPOA
extends Servant
implements InvokeHandler,
ArchiveBulkSenderOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:alma/archive/ArchiveBulkSender:1.0", "IDL:alma/ACS/CharacteristicModel:1.0", "IDL:alma/ACS/CharacteristicComponent:1.0", "IDL:alma/bulkdata/BulkDataSender:1.0", "IDL:alma/ACS/PingableResource:1.0", "IDL:alma/ACS/ACSComponent:1.0"};

    public ArchiveBulkSender _this() {
        return ArchiveBulkSenderHelper.narrow(this._this_object());
    }

    public ArchiveBulkSender _this(ORB oRB) {
        return ArchiveBulkSenderHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                try {
                    outputStream = responseHandler.createReply();
                    this.startSend();
                }
                catch (AVStartSendErrorEx aVStartSendErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVStartSendErrorExHelper.write((OutputStream)outputStream, (AVStartSendErrorEx)aVStartSendErrorEx);
                }
                break;
            }
            case 1: {
                outputStream = responseHandler.createReply();
                outputStream.write_string(this.name());
                break;
            }
            case 2: {
                outputStream = responseHandler.createReply();
                CharacteristicComponentDescHelper.write((OutputStream)outputStream, (CharacteristicComponentDesc)this.descriptor());
                break;
            }
            case 3: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.ping());
                break;
            }
            case 4: {
                try {
                    outputStream = responseHandler.createReply();
                    this.stopSend();
                }
                catch (AVStopSendErrorEx aVStopSendErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVStopSendErrorExHelper.write((OutputStream)outputStream, (AVStopSendErrorEx)aVStopSendErrorEx);
                }
                break;
            }
            case 5: {
                outputStream = responseHandler.createReply();
                PropertySetHelper.write((OutputStream)outputStream, (PropertySet)this.get_all_characteristics());
                break;
            }
            case 6: {
                outputStream = responseHandler.createReply();
                ComponentStatesHelper.write((OutputStream)outputStream, (ComponentStates)this.componentState());
                break;
            }
            case 7: {
                try {
                    outputStream = responseHandler.createReply();
                    this.disconnect();
                }
                catch (AVDisconnectErrorEx aVDisconnectErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVDisconnectErrorExHelper.write((OutputStream)outputStream, (AVDisconnectErrorEx)aVDisconnectErrorEx);
                }
                break;
            }
            case 8: {
                try {
                    outputStream = responseHandler.createReply();
                    this.paceData();
                }
                catch (AVPaceDataErrorEx aVPaceDataErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVPaceDataErrorExHelper.write((OutputStream)outputStream, (AVPaceDataErrorEx)aVPaceDataErrorEx);
                }
                break;
            }
            case 9: {
                try {
                    BulkDataReceiver bulkDataReceiver = BulkDataReceiverHelper.read((InputStream)inputStream);
                    outputStream = responseHandler.createReply();
                    this.connect(bulkDataReceiver);
                }
                catch (AVConnectErrorEx aVConnectErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVConnectErrorExHelper.write((OutputStream)outputStream, (AVConnectErrorEx)aVConnectErrorEx);
                }
                break;
            }
            case 10: {
                String string2 = inputStream.read_string();
                outputStream = responseHandler.createReply();
                this.getBulkData(string2);
                break;
            }
            case 11: {
                String string3 = inputStream.read_string();
                outputStream = responseHandler.createReply();
                stringSeqHelper.write((OutputStream)outputStream, (String[])this.find_characteristic(string3));
                break;
            }
            case 12: {
                try {
                    String string4 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_any(this.get_characteristic_by_name(string4));
                    break;
                }
                catch (NoSuchCharacteristic noSuchCharacteristic) {
                    outputStream = responseHandler.createExceptionReply();
                    NoSuchCharacteristicHelper.write((OutputStream)outputStream, (NoSuchCharacteristic)noSuchCharacteristic);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("startSend", new Integer(0));
        m_opsHash.put("_get_name", new Integer(1));
        m_opsHash.put("descriptor", new Integer(2));
        m_opsHash.put("ping", new Integer(3));
        m_opsHash.put("stopSend", new Integer(4));
        m_opsHash.put("get_all_characteristics", new Integer(5));
        m_opsHash.put("_get_componentState", new Integer(6));
        m_opsHash.put("disconnect", new Integer(7));
        m_opsHash.put("paceData", new Integer(8));
        m_opsHash.put("connect", new Integer(9));
        m_opsHash.put("getBulkData", new Integer(10));
        m_opsHash.put("find_characteristic", new Integer(11));
        m_opsHash.put("get_characteristic_by_name", new Integer(12));
    }
}

