/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.editor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.internal.OawLog;

public class EditorImages {
    public static final String EXTENSION = "extension.gif";
    public static final String PRIVATE_EXTENSION = "extension_private.gif";
    public static final String CREATE_EXTENSION = "extension_create.gif";
    public static final String PRIVATE_CREATE_EXTENSION = "extension_private_create.gif";
    public static final String OPERATION = "operation.gif";
    public static final String PROPERTY = "property.gif";
    public static final String STATICPROPERTY = "staticproperty.gif";
    public static final String VARIABLE = "variable.gif";
    public static final String TYPE = "type.gif";
    public static final String PACKAGE = "package.gif";
    public static final String STATEMENT = "statement.gif";
    public static final String ERROR_CHECK = "check_error.gif";
    public static final String WARNING_CHECK = "check_warning.gif";
    public static final String XPAND_TEMPLATE = "xpand_template.gif";
    public static final String XPAND_DEFINE = "xpand_define.gif";
    public static final String XPAND_AROUND = "xpand_around.gif";
    public static final String NS_IMPORT = "import_ns.gif";
    public static final String EXT_IMPORT = "import_ext.gif";
    public static final String SEARCH_DECLARATIONS = "search_declarations.gif";
    public static final String SEARCH_REFERENCES = "search_references.gif";
    private static ImageRegistry imageRegistry;
    private static URL ICON_BASE_URL;

    static {
        ICON_BASE_URL = null;
        ICON_BASE_URL = OawPlugin.getDefault().getBundle().getEntry("icons/");
        EditorImages.initializeImageRegistry();
    }

    private static void declareImages() {
        Field[] fs;
        Field[] fieldArray = fs = EditorImages.class.getFields();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getType().equals(String.class) && Modifier.isFinal(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())) {
                try {
                    EditorImages.declareRegistryImage((String)f.get(null), (String)f.get(null));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)EditorImages.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            OawLog.logError(me);
        }
        imageRegistry.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            EditorImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(OawPlugin.getStandardDisplay());
        EditorImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return EditorImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return EditorImages.getImageRegistry().getDescriptor(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

