/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;

public class SearchMatch {
    private int offSet;
    private int length;
    private IStorage storage;

    public SearchMatch(int offSet, int length, IStorage file) {
        this.offSet = offSet;
        this.length = length;
        this.storage = file;
    }

    public int getOffSet() {
        return this.offSet;
    }

    public int getLength() {
        return this.length;
    }

    public IFile getFile() {
        return this.storage instanceof IFile ? (IFile)this.storage : null;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public int hashCode() {
        return this.storage.getFullPath().hashCode() * this.offSet * this.length;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SearchMatch) {
            SearchMatch tc = (SearchMatch)obj;
            return tc.getFile().equals((Object)this.getFile()) && tc.getOffSet() == this.getOffSet() && tc.getLength() == this.getLength();
        }
        return false;
    }

    public String toString() {
        return this.getFile().getFullPath() + ":" + this.getOffSet() + "(+" + this.getLength() + ")";
    }
}

