/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.metamodel.jdt;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.openarchitectureware.expression.TypeNameUtil;
import org.openarchitectureware.internal.OawLog;

public class JdtSignatureDecoder {
    private static final String IDENTIFIER = "\\w+(?:[\\./]\\w+)*";
    private static Map<String, String> collectiontypesCache = new WeakHashMap<String, String>();
    private static final Pattern SIG_PRIMITIVES = Pattern.compile("\\A([BCDFIJSVZ])\\z");
    private static final Pattern SIG_TYPEVARIABLE = Pattern.compile("\\AT(\\w+(?:[\\./]\\w+)*);\\z");
    private static final Pattern SIG_ARRAY = Pattern.compile("\\A\\[(.+)\\z");
    private static final Pattern SIG_CAPTURE = Pattern.compile("\\A(!.+)\\z");
    private static final Pattern SIG_CLASSTYPE = Pattern.compile("\\A([LQ])(.+);\\z");
    private static final String OPTIONALTYPEPARAMETERS = "(<(.+)>)?";
    private static final Pattern SIG_TYPEARGUMENTS = Pattern.compile("\\A(\\w+(?:[\\./]\\w+)*)(<(.+)>)?(?:\\$.+)?\\z");

    public static String decodeTypeSignature(String signature, IType usingType) {
        if (signature == null || signature.length() == 0) {
            return signature;
        }
        Matcher matcher = null;
        matcher = SIG_PRIMITIVES.matcher(signature);
        if (matcher.matches()) {
            return JdtSignatureDecoder.decodePrimitiveSignature(matcher.group(1), usingType);
        }
        matcher = SIG_TYPEVARIABLE.matcher(signature);
        if (matcher.matches()) {
            return JdtSignatureDecoder.decodeIdentifier(matcher.group(1), usingType);
        }
        matcher = SIG_ARRAY.matcher(signature);
        if (matcher.matches()) {
            return JdtSignatureDecoder.decodeArraySignature(matcher.group(1), usingType);
        }
        matcher = SIG_CAPTURE.matcher(signature);
        if (matcher.matches()) {
            return JdtSignatureDecoder.decodeCaptureSignature(matcher.group(1), usingType);
        }
        matcher = SIG_CLASSTYPE.matcher(signature);
        if (matcher.matches()) {
            return JdtSignatureDecoder.decodeClasstypeSignature(matcher.group(2), usingType);
        }
        try {
            String[][] result = usingType.resolveType(Signature.toString((String)signature));
            if (result == null) {
                return Signature.toString((String)signature).replaceAll("\\.", "::");
            }
            if (result.length > 0) {
                StringBuffer buff = new StringBuffer();
                int i = 0;
                while (i < result[0].length) {
                    String part = result[0][i];
                    buff.append(part);
                    if (i < result[0].length - 1) {
                        buff.append(".");
                    }
                    ++i;
                }
                String fqn = buff.toString();
                return fqn.replaceAll("\\.", "::");
            }
        }
        catch (JavaModelException e) {
            OawLog.logError(e);
        }
        return null;
    }

    private static String decodeIdentifier(String signature, IType usingType) {
        block9: {
            try {
                if (signature != null && usingType != null) {
                    String[][] result = usingType.resolveType(signature);
                    if (result == null) {
                        return TypeNameUtil.convertJavaTypeName((String)signature);
                    }
                    if (result.length > 0) {
                        StringBuffer buff = new StringBuffer();
                        int i = 0;
                        while (i < result[0].length) {
                            String part = result[0][i];
                            buff.append(part);
                            if (i < result[0].length - 1) {
                                buff.append(".");
                            }
                            ++i;
                        }
                        String fqn = buff.toString();
                        return TypeNameUtil.convertJavaTypeName((String)fqn);
                    }
                    break block9;
                }
                if (signature != null) {
                    return TypeNameUtil.convertJavaTypeName((String)signature);
                }
                return null;
            }
            catch (JavaModelException e) {
                OawLog.logError(e);
            }
            catch (IllegalArgumentException e) {
                OawLog.logError(e);
            }
        }
        return null;
    }

    private static String decodePrimitiveSignature(String group, IType usingType) {
        assert (group.length() == 1);
        char type = group.charAt(0);
        switch (type) {
            case 'B': {
                return "Integer";
            }
            case 'C': {
                return "String";
            }
            case 'D': {
                return "Real";
            }
            case 'F': {
                return "Real";
            }
            case 'I': {
                return "Integer";
            }
            case 'J': {
                return "Integer";
            }
            case 'S': {
                return "Integer";
            }
            case 'V': {
                return "Void";
            }
            case 'Z': {
                return "Boolean";
            }
        }
        assert (false);
        return null;
    }

    private static String decodeArraySignature(String signature, IType usingType) {
        String innerType = JdtSignatureDecoder.decodeTypeSignature(signature, usingType);
        return "List[" + innerType + "]";
    }

    private static String decodeCaptureSignature(String signature, IType usingType) {
        throw new UnsupportedOperationException("cannot handle type captures: " + signature);
    }

    private static String decodeClasstypeSignature(String signature, IType usingType) {
        Matcher matcher = SIG_TYPEARGUMENTS.matcher(signature);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(signature);
        }
        String identifier = JdtSignatureDecoder.decodeIdentifier(matcher.group(1), usingType);
        String innerType = matcher.group(3);
        if (innerType == null || !JdtSignatureDecoder.isCollectionType(identifier)) {
            return identifier;
        }
        String coltype = JdtSignatureDecoder.getCollectionType(identifier);
        innerType = JdtSignatureDecoder.decodeTypeSignature(innerType, usingType);
        StringBuilder result = new StringBuilder();
        result.append(coltype);
        result.append("[");
        result.append(innerType);
        result.append("]");
        return result.toString();
    }

    private static boolean isCollectionType(String identifier) {
        return JdtSignatureDecoder.getCollectionType(identifier) != null;
    }

    private static String getCollectionType(String identifier) {
        String coltype = collectiontypesCache.get(identifier);
        if (coltype == null) {
            try {
                Class<?> cls = Class.forName(identifier.replaceAll("::", "."));
                if (List.class.isAssignableFrom(cls)) {
                    coltype = "List";
                    collectiontypesCache.put(identifier, coltype);
                } else if (Set.class.isAssignableFrom(cls)) {
                    coltype = "Set";
                    collectiontypesCache.put(identifier, coltype);
                } else if (Collection.class.isAssignableFrom(cls)) {
                    coltype = "Collection";
                    collectiontypesCache.put(identifier, coltype);
                }
            }
            catch (RuntimeException runtimeException) {
                coltype = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                coltype = null;
            }
        }
        return coltype;
    }
}

