/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.ResourceContributor;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.core.builder.OawBuilder;
import org.openarchitectureware.core.builder.OawMarkerManager;
import org.openarchitectureware.core.builder.OawNature;
import org.openarchitectureware.core.internal.JDTUtil;
import org.openarchitectureware.core.internal.OawResourceID;
import org.openarchitectureware.internal.OawLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawProject
implements IOawProject {
    private static final Set<IJavaProject> initializing = new HashSet<IJavaProject>();
    final IJavaProject project;
    private final Map<OawResourceID, IOawResource> resources = new HashMap<OawResourceID, IOawResource>();
    private Set<OawResourceID> fromJar = new HashSet<OawResourceID>();

    public OawProject(IJavaProject resource) {
        this.project = resource;
        try {
            IProject[] ps = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < ps.length) {
                if (initializing.add(this.project)) {
                    try {
                        OawPlugin.getOawModelManager().findProject((IResource)ps[i]);
                    }
                    finally {
                        initializing.remove(this.project);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                if (OawProject.this.fromJar.isEmpty()) {
                    return;
                }
                if (OawProject.this.containsRemovedClassPathEntry(event.getDelta().getAffectedChildren())) {
                    OawProject.this.removeResourcesFromJar();
                }
            }
        }, (int)1);
        Job j = new Job("Initializing " + this.project.getElementName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject p = OawProject.this.project.getProject();
                    if (p.isAccessible() && p.isNatureEnabled(OawNature.NATURE_ID)) {
                        p.build(15, OawBuilder.getBUILDER_ID(), new HashMap(), monitor);
                    }
                }
                catch (CoreException e) {
                    OawLog.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule(this.project.getResource().getWorkspace().getRuleFactory().buildRule());
        j.schedule();
    }

    protected boolean containsRemovedClassPathEntry(IJavaElementDelta[] affectedChildren) {
        int i = 0;
        while (i < affectedChildren.length) {
            IJavaElementDelta delta = affectedChildren[i];
            if ((delta.getFlags() & 0x80) != 0) {
                return true;
            }
            if (this.containsRemovedClassPathEntry(delta.getAffectedChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeResourcesFromJar() {
        for (OawResourceID id : this.fromJar) {
            this.resources.remove(id);
        }
    }

    @Override
    public IOawResource[] getRegisteredResources() {
        return this.resources.values().toArray(new IOawResource[this.resources.size()]);
    }

    @Override
    public IOawResource[] getAllRegisteredResources() {
        HashSet result = new HashSet();
        result.addAll(Arrays.asList(this.getRegisteredResources()));
        IOawProject[] iOawProjectArray = this.getAllReferencedProjects();
        int n = iOawProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOawProject p = iOawProjectArray[n2];
            result.addAll(Arrays.asList(p.getRegisteredResources()));
            ++n2;
        }
        return result.toArray(new IOawResource[this.resources.size()]);
    }

    @Override
    public IOawProject[] getReferencedProjects() {
        HashSet<IOawProject> result = new HashSet<IOawProject>();
        try {
            IProject[] projects;
            IProject[] iProjectArray = projects = this.getProject().getProject().getReferencedProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IOawProject p = OawPlugin.getOawModelManager().findProject((IResource)project);
                if (p != null) {
                    result.add(p);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        return result.toArray(new IOawProject[result.size()]);
    }

    @Override
    public IOawProject[] getAllReferencedProjects() {
        HashSet result = new HashSet();
        IOawProject[] projects = this.getReferencedProjects();
        result.addAll(Arrays.asList(projects));
        IOawProject[] iOawProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IOawProject project = iOawProjectArray[n2];
            result.addAll(Arrays.asList(project.getAllReferencedProjects()));
            ++n2;
        }
        return result.toArray(new IOawProject[result.size()]);
    }

    @Override
    public IJavaProject getProject() {
        return this.project;
    }

    @Override
    public void unregisterOawResource(IOawResource res) {
        if (res != null) {
            if (res.getUnderlyingStorage() instanceof IFile) {
                OawMarkerManager.deleteMarkers((IResource)((IFile)res.getUnderlyingStorage()));
            }
            this.resources.remove(new OawResourceID(res.getFullyQualifiedName(), res.getFileExtension()));
        }
    }

    @Override
    public IOawResource findOawResource(String fqn, String extension) {
        assert (fqn != null);
        assert (extension != null);
        if (OawPlugin.getRegisteredResourceContributorFor(extension) == null) {
            return null;
        }
        IOawResource res = this.findCachedOawResource(fqn, extension);
        if (res != null) {
            return res;
        }
        res = this.loadOawResource(fqn, extension, false);
        if (res != null) {
            return res;
        }
        return this.loadOawResource(fqn, extension, true);
    }

    private IOawResource findCachedOawResource(String fqn, String extension) {
        IOawResource res = this.resources.get(new OawResourceID(fqn, extension));
        if (res == null) {
            return null;
        }
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember(res.getUnderlyingStorage().getFullPath());
        if (workspaceResource != null && workspaceResource.exists()) {
            return res;
        }
        this.resources.remove(new OawResourceID(fqn, extension));
        return null;
    }

    @Override
    public IOawResource loadOawResource(String fqn, String extension, boolean searchJars) {
        HashSet<String> visited = new HashSet<String>();
        return this.loadOawResource2(fqn, extension, searchJars, visited);
    }

    private IOawResource loadOawResource2(String fqn, String extension, boolean searchJars, Set<String> visited) {
        assert (fqn != null);
        assert (extension != null);
        if (visited.contains(this.project.getProject().getName())) {
            return null;
        }
        visited.add(this.project.getProject().getName());
        IStorage storage = JDTUtil.findStorage(this.project, new OawResourceID(fqn, extension), searchJars);
        if (storage != null && (searchJars || storage instanceof IFile)) {
            IOawResource result = null;
            String fileExtension = storage.getName().substring(storage.getName().lastIndexOf(".") + 1);
            ResourceContributor contr = OawPlugin.getRegisteredResourceContributorFor(fileExtension);
            if (contr != null && (result = contr.create(storage, fqn)) != null) {
                this.resources.put(new OawResourceID(fqn, extension), result);
                if (!(storage instanceof IFile)) {
                    this.fromJar.add(new OawResourceID(fqn, extension));
                }
                return result;
            }
        }
        try {
            IProject[] p = this.project.getProject().getReferencedProjects();
            int i = 0;
            while (i < p.length) {
                IProject project = p[i];
                OawProject oawp = (OawProject)OawPlugin.getOawModelManager().findProject((IResource)project);
                if (oawp != null) {
                    IOawResource result = oawp.findCachedOawResource(fqn, extension);
                    if (result != null) {
                        return result;
                    }
                    result = oawp.loadOawResource2(fqn, extension, searchJars, visited);
                    if (result != null) {
                        return result;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        return null;
    }

    @Override
    public IOawResource findOawResource(IStorage file) {
        if (file == null) {
            return null;
        }
        OawResourceID id = JDTUtil.findOawResourceID(this.project, file);
        if (id == null) {
            return null;
        }
        return this.findOawResource(id.name, id.extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(IProgressMonitor monitor) {
        Iterator<IOawResource> iter = new ArrayList<IOawResource>(this.resources.values()).iterator();
        while (iter.hasNext()) {
            IOawResource resource;
            if (monitor.isCanceled()) {
                return;
            }
            IOawResource iOawResource = resource = iter.next();
            synchronized (iOawResource) {
                resource.analyze();
            }
            monitor.worked(1);
        }
    }

    public String toString() {
        return this.project.getPath().toString();
    }
}

