/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.builder;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.openarchitectureware.core.builder.OawMarkerManager;
import org.openarchitectureware.core.builder.OawNature;
import org.openarchitectureware.internal.OawLog;

public class OawNatureUtil {
    public static final boolean addOawNature(IJavaProject jp) {
        block7: {
            try {
                final IProject project = jp.getProject();
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                boolean containsNature = false;
                int i = 0;
                while (i < natures.length) {
                    if (OawNature.NATURE_ID.equals(natures[i])) {
                        containsNature = true;
                    }
                    ++i;
                }
                if (containsNature) break block7;
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = OawNature.NATURE_ID;
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                project.build(15, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    OawLog.logError(e);
                }
                catch (InterruptedException e) {
                    OawLog.logError(e);
                }
                return true;
            }
            catch (CoreException e) {
                OawLog.logError(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean removeOawNature(final IJavaProject jp) {
        try {
            IProjectDescription description = jp.getProject().getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return false;
                }
                if (OawNature.NATURE_ID.equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    jp.getProject().setDescription(description, null);
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                OawMarkerManager.deleteMarkers((IResource)jp.getProject());
                            }
                        }.run((IProgressMonitor)new NullProgressMonitor());
                        return true;
                    }
                    catch (InvocationTargetException e) {
                        OawLog.logError(e);
                        return true;
                    }
                    catch (InterruptedException e) {
                        OawLog.logError(e);
                    }
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            OawLog.logError(e);
        }
        return false;
    }
}

