/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2t.type.emf;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.m2t.type.emf.EmfRegistryMetaModel;
import org.openarchitectureware.type.AbstractTypeImpl;
import org.openarchitectureware.type.Feature;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.type.baseimpl.OperationImpl;
import org.openarchitectureware.type.baseimpl.PropertyImpl;
import org.openarchitectureware.workflow.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassType
extends AbstractTypeImpl {
    private static final Log log = LogFactory.getLog(EClassType.class);
    private EmfRegistryMetaModel emfMetaModel;
    private EClass eClass;

    public EClassType(EmfRegistryMetaModel model, String name, EClass class1) {
        super(model.getTypeSystem(), name);
        this.emfMetaModel = model;
        this.eClass = class1;
    }

    public Feature[] getContributedFeatures() {
        HashSet<Object> result = new HashSet<Object>();
        EList list = this.eClass.getEStructuralFeatures();
        for (final EStructuralFeature feature : list) {
            Type t = this.emfMetaModel.getTypeForETypedElement((ETypedElement)feature);
            if (t == null) {
                log.warn((Object)("Couldn't resolve type for " + this.getTypeName(feature.getEType())));
                continue;
            }
            result.add(new PropertyImpl((Type)this, feature.getName(), t){

                public Object get(Object target) {
                    return ((EObject)target).eGet(feature);
                }

                public void set(Object target, Object newValue) {
                    if (feature.isChangeable() && !feature.isUnsettable() && !feature.isDerived()) {
                        if (feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum)) {
                            EDataType dt = (EDataType)feature.getEType();
                            newValue = this.getReturnType().convert(newValue, dt.getInstanceClass());
                        }
                    } else {
                        throw new UnsupportedOperationException("setting property '" + feature.getName() + "' is not allowed!");
                    }
                    ((EObject)target).eSet(feature, newValue);
                }
            });
        }
        EList operations = this.eClass.getEOperations();
        for (EOperation op : operations) {
            final EList emfParams = op.getEParameters();
            Type[] paramTypes = new Type[emfParams.size()];
            boolean errors = false;
            int i = 0;
            int x = emfParams.size();
            while (i < x) {
                EParameter param = (EParameter)emfParams.get(i);
                paramTypes[i] = this.emfMetaModel.getTypeForETypedElement((ETypedElement)param);
                if (paramTypes[i] == null) {
                    log.warn((Object)("Couldn't resolve type for " + this.getTypeName(param.getEType())));
                    errors = true;
                }
                ++i;
            }
            Type t = this.emfMetaModel.getTypeForETypedElement((ETypedElement)op);
            if (t == null) {
                log.warn((Object)("Couldn't resolve type for " + this.getTypeName(op.getEType())));
                errors = true;
            }
            if (errors) continue;
            result.add(new OperationImpl((Type)this, op.getName(), t, paramTypes){

                protected Object evaluateInternal(Object target, Object[] params) {
                    Class[] paramClasses = new Class[emfParams.size()];
                    int i = 0;
                    int x = emfParams.size();
                    while (i < x) {
                        EParameter param = (EParameter)emfParams.get(i);
                        paramClasses[i] = param.isMany() ? EList.class : param.getEType().getInstanceClass();
                        params[i] = ((Type)this.getParameterTypes().get(i)).convert(params[i], paramClasses[i]);
                        ++i;
                    }
                    try {
                        Method m = target.getClass().getMethod(this.getName(), paramClasses);
                        return m.invoke(target, params);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        for (final EStructuralFeature feature : this.eClass.getEStructuralFeatures()) {
            Type t = this.emfMetaModel.getTypeForETypedElement((ETypedElement)feature);
            if (t == null) {
                log.warn((Object)("Couldn't resolve type for " + this.getTypeName(feature.getEType())));
                continue;
            }
            if (!feature.isChangeable()) continue;
            result.add(new OperationImpl((Type)this, "set" + StringHelper.firstUpper((String)feature.getName()), (Type)this, new Type[]{t}){

                protected Object evaluateInternal(Object target, Object[] params) {
                    Object newValue = params[0];
                    if (newValue != null && feature.getEType() instanceof EDataType && !(feature.getEType() instanceof EEnum)) {
                        EDataType dt = feature.isMany() ? EcorePackage.eINSTANCE.getEEList() : (EDataType)feature.getEType();
                        newValue = ((Type)this.getParameterTypes().get(0)).convert(newValue, dt.getInstanceClass());
                    }
                    ((EObject)target).eSet(feature, newValue);
                    return target;
                }
            });
        }
        return result.toArray(new Feature[result.size()]);
    }

    private String getTypeName(EClassifier type) {
        if (type == null) {
            return "null";
        }
        return type.getName();
    }

    public boolean isInstance(Object o) {
        return this.eClass.isInstance(o);
    }

    public Object newInstance() {
        return this.eClass.getEPackage().getEFactoryInstance().create(this.eClass);
    }

    protected Set<Type> internalGetSuperTypes() {
        EList st = this.eClass.getESuperTypes();
        HashSet<Type> result = new HashSet<Type>();
        for (EClass element : st) {
            result.add(this.emfMetaModel.getTypeForEClassifier((EClassifier)element));
        }
        result.add((Type)this.emfMetaModel.getEobjectType());
        return result;
    }

    public boolean isAbstract() {
        return this.eClass.isAbstract();
    }
}

