/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen.comphelpgen;

import alma.acs.tools.comphelpergen.CompHelperGenerator;
import alma.acs.tools.comphelpergen.generated.ComponentHelperInfo;
import alma.acs.tools.comphelpergen.generated.ComponentInterface;
import alma.tools.idlgen.IDLComponentTester;
import alma.tools.idlgen.comphelpgen.JavaPackageScout;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;

public class ComponentHelperGeneratorProxy {
    private Map<String, IdlInterface> m_interfaceMap;
    private JavaPackageScout m_packageScout;
    private boolean m_verbose;
    private ComponentHelperInfo m_compHelpInfo;

    public ComponentHelperGeneratorProxy(String string, boolean bl) {
        this.m_verbose = bl;
        this.m_compHelpInfo = new ComponentHelperInfo();
        this.m_compHelpInfo.setOutputRootDirectory(string);
    }

    public void setOriginalParseTree(IdlObject idlObject, String string) {
        block3: {
            HashMap<String, IdlInterface> hashMap = new HashMap<String, IdlInterface>();
            this.collectACSComponents(idlObject, hashMap);
            this.m_interfaceMap = hashMap;
            this.m_packageScout = new JavaPackageScout();
            try {
                this.m_packageScout.collectInterfacePackages(idlObject, string);
            }
            catch (RuntimeException runtimeException) {
                if (!this.m_verbose) break block3;
                runtimeException.printStackTrace();
                throw runtimeException;
            }
        }
        if (this.m_verbose) {
            System.out.println("done ComponentHelperGeneratorProxy#setOriginalParseTree.");
        }
    }

    private void collectACSComponents(IdlObject idlObject, HashMap hashMap) {
        if (idlObject.included()) {
            return;
        }
        if (idlObject.kind() == 15 && IDLComponentTester.isACSComponent((IdlInterface)idlObject)) {
            hashMap.put(idlObject.name(), idlObject);
        } else {
            idlObject.reset();
            while (!idlObject.end()) {
                IdlObject idlObject2 = idlObject.current();
                this.collectACSComponents(idlObject2, hashMap);
                idlObject.next();
            }
            idlObject.reset();
        }
    }

    public void generateComponentHelperCode() {
        IdlInterface idlInterface;
        String string2;
        for (String string2 : this.m_interfaceMap.keySet()) {
            idlInterface = this.m_interfaceMap.get(string2);
            String string3 = this.m_packageScout.getPackage(idlInterface);
            String string4 = idlInterface.name();
            if (this.m_verbose) {
                System.out.println("Corba-IF=" + string2 + "  innerIF=" + string4 + "  package=" + string3);
            }
            ComponentInterface componentInterface = new ComponentInterface();
            this.m_compHelpInfo.addComponentInterface(componentInterface);
            String string5 = idlInterface.getId();
            String string6 = string5.substring(0, string5.lastIndexOf(47) + 1) + string2 + ":1.0";
            componentInterface.setCorbaRepositoryId(string6);
            componentInterface.setIdlPackage(string3);
            componentInterface.setComponentClassName(string2);
            if (string4.equals(string2)) continue;
            componentInterface.setInternalInterface(string4);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.m_compHelpInfo.marshal((Writer)stringWriter);
        }
        catch (Exception exception) {
            System.err.println("failed to generate configuration file (xml) for component helper generator:");
            exception.printStackTrace(System.err);
            System.exit(1);
        }
        string2 = stringWriter.toString();
        if (this.m_verbose) {
            System.out.println("\n\nWill invoke component helper generator (ACS module comphelpgen).");
            System.out.println("************ component helper xml ********");
            System.out.println(string2);
        }
        idlInterface = new CompHelperGenerator(this.m_verbose);
        idlInterface.generate(string2);
    }
}

