/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import alma.tools.idlgen.IDLComponentTester;
import alma.tools.idlgen.IdlTreeManipulator;
import alma.tools.idlgen.JavaGenerator;
import alma.tools.idlgen.comphelpgen.ComponentHelperGeneratorProxy;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.IdlParser;

public class XmlIdlCompiler {
    public static final String PROP_DO_GENERATE_COMP_HELPERS = "alma.acs.tools.comphelpergen.doGenerate";
    public static final String PROP_COMP_HELPERS_OUTDIR = "alma.acs.tools.comphelpergen.outRootDir";
    protected static IdlCompiler s_idlCompiler = new IdlCompiler();

    public void compile_file(String string, IdlParser idlParser) {
        Object object2;
        String string2 = System.getProperty("ACS.idl2jbind");
        boolean bl = Boolean.getBoolean(PROP_DO_GENERATE_COMP_HELPERS);
        String string3 = System.getProperty(PROP_COMP_HELPERS_OUTDIR);
        if (IdlCompiler.verbose) {
            System.out.println("XmlIdl options (non-OpenORB):\n  idl2jbindMapping = " + string2 + "\n  doGenerateCompHelpers = " + bl + "\n  compHelperOutDir = " + string3);
        }
        if (bl && string3 == null) {
            System.err.println("can't generate component helper class(es) because no output directory is given in alma.acs.tools.comphelpergen.outRootDir");
            bl = false;
        }
        IdlTreeManipulator idlTreeManipulator = new IdlTreeManipulator(JavaGenerator.getNamingConventions());
        ComponentHelperGeneratorProxy componentHelperGeneratorProxy = null;
        if (bl) {
            componentHelperGeneratorProxy = new ComponentHelperGeneratorProxy(string3, IdlCompiler.verbose);
        } else if (IdlCompiler.verbose) {
            System.out.println("no code generation for component helper classes was selected...");
        }
        IdlObject idlObject = idlParser.compile_idl(string);
        if (IdlParser.totalError != 0) {
            String string4 = "there are errors...compilation process stopped !";
            throw new RuntimeException(string4);
        }
        if (IdlCompiler.verbose) {
            System.out.println("\n**** the original idl parse tree ****");
            idlTreeManipulator.recursivePrint(idlObject, 0);
            System.out.println("\n**** end of original idl parse tree ****\n");
        }
        IDLComponentTester.collectInterfaces(idlObject);
        if (componentHelperGeneratorProxy != null) {
            try {
                componentHelperGeneratorProxy.setOriginalParseTree(idlObject, IdlCompiler.packageName);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("failed to parse Java packages:");
                System.err.println(runtimeException.toString());
                System.err.println("Will disable component helper generation.");
                componentHelperGeneratorProxy = null;
                bl = false;
            }
        }
        if (IdlCompiler.verbose) {
            System.out.println("\n**** detecting typedef'd xml entity structs ****");
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        idlTreeManipulator.findXmlTypedefNodes(idlObject, linkedHashSet);
        if (IdlCompiler.verbose) {
            for (Object object2 : linkedHashSet) {
                System.out.println(IdlTreeManipulator.getTypeName(object2.kind()) + "::" + object2.getId());
            }
        }
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        linkedHashSet2.addAll(linkedHashSet);
        if (IdlCompiler.verbose) {
            System.out.println("\n**** detecting usage of xml entity structs ****");
        }
        idlTreeManipulator.findXmlEntityNodes(idlObject, Collections.unmodifiableSet(linkedHashSet), linkedHashSet2);
        idlTreeManipulator.resetGraph(idlObject);
        if (IdlCompiler.verbose) {
            System.out.println("\n**** nodes that need code generation ****");
            object2 = linkedHashSet2.iterator();
            while (object2.hasNext()) {
                IdlObject idlObject2 = (IdlObject)object2.next();
                if (idlObject2.kind() == 10) continue;
                System.out.println(IdlTreeManipulator.getTypeName(idlObject2.kind()) + "::" + idlObject2.name() + ": " + idlObject2.getId());
            }
            System.out.println("\n**** the manipulated idl parse tree ****");
            idlTreeManipulator.recursivePrint(idlObject, 0);
        }
        if (IdlCompiler.verbose) {
            System.out.println("\n**** Java code generation ****");
        }
        idlTreeManipulator.resetGraph(idlObject);
        object2 = new JavaGenerator(linkedHashSet, linkedHashSet2);
        ((JavaGenerator)((Object)object2)).setIdlStruct2JavaBindingClassMappings(string2);
        object2.translateData(idlObject, IdlCompiler.packageName);
        if (IdlCompiler.verbose) {
            System.out.println("\n**** done with Java code generation ****");
        }
        if (componentHelperGeneratorProxy != null) {
            System.out.println("ALMA IDL compiler done, now invoking component helper code generator...");
            componentHelperGeneratorProxy.generateComponentHelperCode();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            IdlCompiler.display_help();
        }
        IdlParser idlParser = IdlCompiler.createIDLParser((String[])stringArray);
        if (IdlCompiler.idl_file_name.length == 0) {
            IdlCompiler.display_help();
        }
        XmlIdlCompiler xmlIdlCompiler = new XmlIdlCompiler();
        try {
            Hashtable hashtable = (Hashtable)IdlCompiler.definedMacros.clone();
            for (int i = 0; i < IdlCompiler.idl_file_name.length; ++i) {
                IdlCompiler.definedMacros = hashtable;
                System.out.println("ACS IDL compilation for " + IdlCompiler.idl_file_name[i]);
                xmlIdlCompiler.compile_file(IdlCompiler.idl_file_name[i], idlParser);
            }
        }
        catch (Exception exception) {
            System.err.println("ACS IDL compilation failed!");
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

