/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import alma.tools.idlgen.IDLComponentTester;
import alma.tools.idlgen.NamingConventions;
import java.util.Set;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlStruct;
import org.openorb.compiler.object.IdlTypeDef;

public class IdlTreeManipulator {
    public static final String XML_WRAPPER_STRUCT_NAME = "XmlEntityStruct";
    private NamingConventions m_namingConventions;
    private static String[] s_indentations = new String[]{"", "  ", "    ", "      ", "        ", "          "};

    public IdlTreeManipulator(NamingConventions namingConventions) {
        this.m_namingConventions = namingConventions;
    }

    public void findXmlTypedefNodes(IdlObject idlObject, Set set) {
        IdlStruct idlStruct;
        IdlObject idlObject2;
        if (idlObject.kind() == 13 && ((IdlTypeDef)idlObject).type().kind() == 10 && (idlObject2 = (IdlIdent)((IdlTypeDef)idlObject).type()).internalObject().kind() == 3 && (idlStruct = (IdlStruct)idlObject2.internalObject()).name().equalsIgnoreCase(XML_WRAPPER_STRUCT_NAME)) {
            set.add(idlObject);
        }
        idlObject.reset();
        while (!idlObject.end()) {
            idlObject2 = idlObject.current();
            this.findXmlTypedefNodes(idlObject2, set);
            idlObject.next();
        }
    }

    public boolean findXmlEntityNodes(IdlObject idlObject, Set set, Set set2) {
        IdlInterface idlInterface;
        boolean bl;
        block9: {
            block7: {
                block8: {
                    bl = false;
                    if (idlObject.kind() == 15 && !IDLComponentTester.isACSComponent(idlInterface = (IdlInterface)idlObject) && !IDLComponentTester.isACSOffshoot(idlInterface)) {
                        return false;
                    }
                    if (idlObject.kind() != 10) break block7;
                    idlInterface = ((IdlIdent)idlObject).internalObject();
                    if (!set.contains(idlInterface)) break block8;
                    bl = true;
                    break block9;
                }
                if (idlInterface.kind() != 13) break block9;
                IdlObject idlObject2 = ((IdlTypeDef)idlInterface).type();
                if (idlObject2.kind() == 9) {
                    idlObject2.reset();
                    idlObject2 = idlObject2.current();
                }
                bl = this.findXmlEntityNodes(idlObject2, set, set2);
                break block9;
            }
            idlObject.reset();
            while (!idlObject.end()) {
                idlInterface = idlObject.current();
                if (this.findXmlEntityNodes((IdlObject)idlInterface, set, set2)) {
                    bl = true;
                }
                idlObject.next();
            }
        }
        if (bl) {
            this.renameXmlBindingNode(idlObject);
            set2.add(idlObject);
            if (this.isPLGenerationRoot(idlObject)) {
                idlObject.reset();
                while (!idlObject.end()) {
                    idlInterface = idlObject.current();
                    set2.add(idlInterface);
                    idlObject.next();
                }
            }
        }
        return bl;
    }

    public boolean isPLGenerationRoot(IdlObject idlObject) {
        return idlObject.kind() == 15 || idlObject.kind() == 13;
    }

    public void renameXmlBindingNode(IdlObject idlObject) {
        if (idlObject.name() == null) {
            return;
        }
        switch (idlObject.kind()) {
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 24: 
            case 27: 
            case 28: {
                String string = idlObject.name() + this.m_namingConventions.getSuffix();
                if (IdlCompiler.verbose) {
                    System.out.println("changing name from " + idlObject.name() + " to " + string);
                }
                idlObject.name(string);
            }
        }
    }

    public void resetGraph(IdlObject idlObject) {
        idlObject.reset();
        while (!idlObject.end()) {
            IdlObject idlObject2 = idlObject.current();
            this.resetGraph(idlObject2);
            idlObject.next();
        }
        idlObject.reset();
        idlObject.setId(null);
    }

    public void recursivePrint(IdlObject idlObject, int n) {
        IdlInterface idlInterface;
        Object object;
        System.out.print(IdlTreeManipulator.getIndentation(n));
        System.out.print(IdlTreeManipulator.getTypeName(idlObject.kind()));
        if (idlObject.name() != null) {
            System.out.print("{" + idlObject.getId() + "}");
        }
        if (idlObject.kind() == 15 && !((Vector)(object = (idlInterface = (IdlInterface)idlObject).getInheritance())).isEmpty()) {
            System.out.print(" :: " + ((IdlInterface)((Vector)object).get(0)).name());
        }
        if (idlObject.kind() == 10) {
            idlInterface = ((IdlIdent)idlObject).internalObject();
            if (IdlCompiler.verbose) {
                try {
                    object = idlInterface.name() != null ? idlInterface.getId() : "NotAvailable";
                    IdlObject idlObject2 = idlInterface.final_object();
                    String string = idlObject2 != null && idlObject2.name() != null ? idlObject2.getId() : "NotAvailable";
                    System.out.print(" (internal/final: " + (String)object + "/" + string);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
        }
        if (IdlCompiler.verbose) {
            System.out.println();
        }
        idlObject.reset();
        while (!idlObject.end()) {
            idlInterface = idlObject.current();
            this.recursivePrint((IdlObject)idlInterface, n + 1);
            idlObject.next();
        }
    }

    private static String getIndentation(int n) {
        if (n > 5) {
            n = 5;
        }
        return s_indentations[n];
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 0: {
                return "root";
            }
            case 1: {
                return "module";
            }
            case 2: {
                return "enum";
            }
            case 3: {
                return "struct";
            }
            case 4: {
                return "union";
            }
            case 5: {
                return "string";
            }
            case 6: {
                return "wstring";
            }
            case 7: {
                return "const";
            }
            case 8: {
                return "simple";
            }
            case 9: {
                return "sequence";
            }
            case 10: {
                return "identifier";
            }
            case 11: {
                return "structmember";
            }
            case 12: {
                return "unionmember";
            }
            case 13: {
                return "typedef";
            }
            case 14: {
                return "exeption";
            }
            case 15: {
                return "interface";
            }
            case 16: {
                return "operation";
            }
            case 17: {
                return "attribute";
            }
            case 18: {
                return "forward_interface";
            }
            case 19: {
                return "parameter";
            }
            case 20: {
                return "raises";
            }
            case 21: {
                return "context";
            }
            case 22: {
                return "enum_member";
            }
            case 23: {
                return "any";
            }
            case 24: {
                return "array";
            }
            case 25: {
                return "native";
            }
            case 26: {
                return "fixed";
            }
            case 27: {
                return "value_box";
            }
            case 28: {
                return "value";
            }
            case 29: {
                return "state_member";
            }
            case 30: {
                return "factory";
            }
            case 31: {
                return "factory_member";
            }
            case 32: {
                return "value_inheritance";
            }
            case 33: {
                return "forward_value";
            }
            case 34: {
                return "include";
            }
            case 35: {
                return "import";
            }
        }
        return "???";
    }
}

