/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import java.util.HashMap;
import java.util.Vector;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;

public class IDLComponentTester {
    public static final String ACSCOMPONENT_IDLTYPE = "IDL:alma/ACS/ACSComponent:1.0";
    public static final String ACSOFFSHOOT_IDLTYPE = "IDL:alma/ACS/OffShoot:1.0";
    private static HashMap<String, IdlInterface> s_allInterfaces;

    public static void collectInterfaces(IdlObject idlObject) {
        s_allInterfaces = new HashMap();
        IDLComponentTester.collectInterfaces(idlObject, s_allInterfaces);
    }

    private static void collectInterfaces(IdlObject idlObject, HashMap<String, IdlInterface> hashMap) {
        if (idlObject.kind() == 15) {
            hashMap.put(idlObject.name(), (IdlInterface)idlObject);
        } else {
            idlObject.reset();
            while (!idlObject.end()) {
                IdlObject idlObject2 = idlObject.current();
                IDLComponentTester.collectInterfaces(idlObject2, hashMap);
                idlObject.next();
            }
            idlObject.reset();
        }
    }

    public static boolean isACSComponent(IdlInterface idlInterface) {
        return IDLComponentTester.isACSInterface(idlInterface, ACSCOMPONENT_IDLTYPE);
    }

    public static boolean isACSOffshoot(IdlInterface idlInterface) {
        return IDLComponentTester.isACSInterface(idlInterface, ACSOFFSHOOT_IDLTYPE);
    }

    protected static boolean isACSInterface(IdlInterface idlInterface, String string) {
        if (s_allInterfaces == null) {
            throw new NullPointerException("must first call #collectInterfaces before calling #isACSComponent");
        }
        boolean bl = false;
        if (idlInterface.getId().equals(string)) {
            bl = true;
        } else {
            Vector vector = idlInterface.getInheritance();
            for (IdlInterface idlInterface2 : vector) {
                IdlInterface idlInterface3 = s_allInterfaces.get(idlInterface2.name());
                if (idlInterface3 == null) {
                    throw new NullPointerException("failed to retrieve IdlInterface object for interface " + idlInterface2.name());
                }
                if (!IDLComponentTester.isACSInterface(idlInterface3, string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

