/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.text.AttributedCharacterIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;
import org.openide.text.PrintSettings;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

final class DefaultPrintable
implements Printable {
    private AttributedCharacterIterator[] styledTexts;
    private int startPage = -1;
    private ArrayList textLayouts;
    private int[] pageIndices;
    private int pageIndicesSize;
    private int currentLayout;
    private int currentStyledText;
    private LineBreakMeasurer lineBreakMeasurer;
    private int maxPage;
    private int currentLine;
    private ArrayList startLayouts;
    private int[] lineIndices;
    private static final int ARG_SIZE = 3;
    private Object[] pageArgs;
    private MessageFormat header;
    private boolean printHeader;
    private MessageFormat footer;
    private boolean printFooter;
    private static PrintSettings printSettings;
    private CancellationPanel cancellationPanel;
    private Dialog cancellationDialog;
    private static Font fontInstance;
    static /* synthetic */ Class class$org$openide$text$PrintSettings;
    static /* synthetic */ Class class$org$openide$text$DefaultPrintable;

    private DefaultPrintable(AttributedCharacterIterator[] iter, String filename) {
        if (iter == null || iter.length == 0) {
            throw new IllegalArgumentException();
        }
        if (printSettings == null) {
            printSettings = (PrintSettings)SharedClassObject.findObject(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = DefaultPrintable.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings, true);
        }
        DefaultPrintable.replaceEmptyIterators(iter);
        this.styledTexts = iter;
        this.textLayouts = new ArrayList(100);
        this.pageIndices = new int[50];
        this.pageIndicesSize = 0;
        this.currentLayout = 0;
        this.currentStyledText = 0;
        this.lineBreakMeasurer = null;
        this.maxPage = Integer.MAX_VALUE;
        this.currentLine = 0;
        this.startLayouts = new ArrayList(10);
        this.lineIndices = new int[this.pageIndices.length];
        this.pageArgs = new Object[3];
        this.pageArgs[2] = filename;
        this.pageArgs[1] = new Date(System.currentTimeMillis());
        this.header = new MessageFormat(DefaultPrintable.getHeaderFormat());
        this.printHeader = !DefaultPrintable.getHeaderFormat().equals("");
        this.footer = new MessageFormat(DefaultPrintable.getFooterFormat());
        this.printFooter = !DefaultPrintable.getFooterFormat().equals("");
    }

    public DefaultPrintable(Document doc) {
        this(DefaultPrintable.getIterators(doc), DefaultPrintable.getFilename(doc));
    }

    public int print(Graphics g, PageFormat pf, int pageNo) throws PrinterException {
        boolean processDummy = false;
        if (this.startPage == -1) {
            processDummy = true;
            this.startPage = pageNo;
        }
        if (processDummy) {
            int i = 0;
            while (i < this.startPage) {
                this.printImpl(g, pf, i, false);
                ++i;
            }
        }
        return this.printImpl(g, pf, pageNo, true);
    }

    private int printImpl(Graphics g, PageFormat pf, int pageNo, boolean print) throws PrinterException {
        float dx;
        float center;
        if (pageNo > this.maxPage) {
            this.closeDialog();
            return 1;
        }
        if (pageNo < 0) {
            this.closeDialog();
            throw new IllegalArgumentException("Illegal page number=" + pageNo);
        }
        if (g instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)g)).getPrinterJob())) {
            this.closeDialog();
            throw new PrinterAbortException();
        }
        if (this.cancellationPanel == null && g instanceof PrinterGraphics) {
            PrinterJob pJob = ((PrinterGraphics)((Object)g)).getPrinterJob();
            this.createCancellationPanel(pJob);
        }
        if (this.cancellationPanel != null) {
            int pageNumber = print ? pageNo : this.startPage;
            this.cancellationPanel.setPageno(pageNumber);
            this.packDialog();
        }
        boolean startLine = false;
        int correction = 3;
        g.setColor(Color.black);
        Graphics2D graphics = (Graphics2D)g;
        Point2D.Float pen = new Point2D.Float(this.getImageableXPatch(pf), this.getImageableYPatch(pf));
        this.pageArgs[0] = new Integer(pageNo + 1);
        float pageBreakCorrection = 0.0f;
        TextLayout headerString = null;
        TextLayout footerString = null;
        if (this.printHeader) {
            headerString = new TextLayout(this.header.format(this.pageArgs), DefaultPrintable.getHeaderFont(), graphics.getFontRenderContext());
            pageBreakCorrection += headerString.getAscent() + (headerString.getDescent() + headerString.getLeading()) * 2.0f;
        }
        if (this.printFooter) {
            footerString = new TextLayout(this.footer.format(this.pageArgs), DefaultPrintable.getFooterFont(), graphics.getFontRenderContext());
            pageBreakCorrection += footerString.getAscent() * 2.0f + footerString.getDescent() + footerString.getLeading();
        }
        float wrappingWidth = DefaultPrintable.wrap() ? (float)pf.getImageableWidth() - (float)correction : Float.MAX_VALUE;
        float pageBreak = (float)pf.getImageableHeight() + (float)pf.getImageableY() - pageBreakCorrection;
        FontRenderContext frCtx = graphics.getFontRenderContext();
        boolean pageExists = false;
        TextLayout layout = this.layoutForPage(pageNo, wrappingWidth, frCtx);
        while (pen.y < pageBreak) {
            float dx2;
            if (layout == null) {
                this.maxPage = pageNo;
                break;
            }
            if (!pageExists) {
                if (this.printHeader && headerString != null) {
                    pen.y += headerString.getAscent();
                    center = DefaultPrintable.computeStart(headerString.getBounds(), (float)pf.getImageableWidth(), DefaultPrintable.getHeaderAlignment());
                    float f = dx = headerString.isLeftToRight() ? center : wrappingWidth - headerString.getAdvance() - center;
                    if (print) {
                        headerString.draw(graphics, pen.x + dx, pen.y);
                    }
                    pen.y += (headerString.getDescent() + headerString.getLeading()) * 2.0f;
                }
                pageExists = true;
            }
            pen.y += layout.getAscent() * DefaultPrintable.getLineAscentCorrection();
            float f = dx2 = layout.isLeftToRight() ? 0.0f : wrappingWidth - layout.getAdvance();
            if (print) {
                layout.draw(graphics, (float)correction + pen.x + dx2, pen.y);
            }
            pen.y += (layout.getDescent() + layout.getLeading()) * DefaultPrintable.getLineAscentCorrection();
            layout = this.nextLayout(wrappingWidth, frCtx);
        }
        if (this.printFooter && pageExists && footerString != null) {
            pen.y = pageBreak;
            pen.y += footerString.getAscent() * 2.0f;
            center = DefaultPrintable.computeStart(footerString.getBounds(), (float)pf.getImageableWidth(), DefaultPrintable.getFooterAlignment());
            float f = dx = footerString.isLeftToRight() ? 0.0f + center : wrappingWidth - footerString.getAdvance() - center;
            if (print) {
                footerString.draw(graphics, pen.x + dx, pen.y);
            }
        }
        if (g instanceof PrinterGraphics && this.isCancelled(((PrinterGraphics)((Object)g)).getPrinterJob())) {
            this.closeDialog();
            throw new PrinterAbortException();
        }
        if (!pageExists) {
            this.closeDialog();
            return 1;
        }
        return 0;
    }

    private float getImageableXPatch(PageFormat pf) {
        if (pf.getOrientation() == 0) {
            double ret = pf.getPaper().getHeight() - (pf.getImageableX() + pf.getImageableWidth());
            return Math.round(ret);
        }
        return (float)pf.getImageableX();
    }

    private float getImageableYPatch(PageFormat pf) {
        if (pf.getOrientation() == 0) {
            double ret = pf.getPaper().getWidth() - (pf.getImageableY() + pf.getImageableHeight());
            return Math.round(ret);
        }
        return (float)pf.getImageableY();
    }

    private boolean isNewline(TextLayout tl, int currentLine) {
        if (currentLine >= this.startLayouts.size()) {
            return false;
        }
        return this.startLayouts.get(currentLine) == tl;
    }

    private static float computeStart(Rectangle2D rect, float width, int alignment) {
        float x = rect instanceof Rectangle2D.Float ? ((Rectangle2D.Float)rect).width : (float)((Rectangle2D.Double)rect).width;
        if (x >= width) {
            return 0.0f;
        }
        switch (alignment) {
            case 0: {
                return 0.0f;
            }
            case 2: {
                return width - x;
            }
        }
        return (width - x) / 2.0f;
    }

    private TextLayout nextLayout(float wrappingWidth, FontRenderContext frc) {
        TextLayout l;
        if (this.currentLayout == this.textLayouts.size()) {
            LineBreakMeasurer old = this.lineBreakMeasurer;
            LineBreakMeasurer measurer = this.getMeasurer(frc);
            if (measurer == null) {
                return null;
            }
            l = measurer.nextLayout(wrappingWidth);
            this.textLayouts.add(l);
            if (old != measurer) {
                this.startLayouts.add(l);
            }
        } else {
            l = (TextLayout)this.textLayouts.get(this.currentLayout);
        }
        ++this.currentLayout;
        return l;
    }

    private TextLayout layoutForPage(int pageNo, float wrappingWidth, FontRenderContext frc) {
        if (pageNo > this.pageIndicesSize + 1) {
            throw new IllegalArgumentException("Page number " + pageNo + " is bigger than array size " + (this.pageIndicesSize + 1));
        }
        if (pageNo == this.pageIndicesSize) {
            if (this.pageIndicesSize >= this.pageIndices.length) {
                this.pageIndices = DefaultPrintable.increaseArray(this.pageIndices);
                this.lineIndices = DefaultPrintable.increaseArray(this.lineIndices);
            }
            this.pageIndices[this.pageIndicesSize] = Math.max(this.textLayouts.size() - 1, 0);
            this.lineIndices[this.pageIndicesSize++] = Math.max(this.startLayouts.size() - 1, 0);
        }
        this.currentLayout = this.pageIndices[pageNo];
        return this.nextLayout(wrappingWidth, frc);
    }

    private LineBreakMeasurer getMeasurer(FontRenderContext frc) {
        if (this.lineBreakMeasurer == null) {
            this.lineBreakMeasurer = new LineBreakMeasurer(this.styledTexts[this.currentStyledText], frc);
        } else if (this.lineBreakMeasurer.getPosition() >= this.styledTexts[this.currentStyledText].getEndIndex()) {
            if (this.currentStyledText == this.styledTexts.length - 1) {
                return null;
            }
            this.lineBreakMeasurer = new LineBreakMeasurer(this.styledTexts[++this.currentStyledText], frc);
        }
        return this.lineBreakMeasurer;
    }

    private static boolean wrap() {
        return printSettings.getWrap();
    }

    private static String getHeaderFormat() {
        return printSettings.getHeaderFormat();
    }

    private static String getFooterFormat() {
        return printSettings.getFooterFormat();
    }

    private static Font getHeaderFont() {
        return printSettings.getHeaderFont();
    }

    private static Font getFooterFont() {
        return printSettings.getFooterFont();
    }

    private static int getFooterAlignment() {
        return printSettings.getFooterAlignment();
    }

    private static int getHeaderAlignment() {
        return printSettings.getHeaderAlignment();
    }

    private static float getLineAscentCorrection() {
        return printSettings.getLineAscentCorrection();
    }

    private static boolean lineNumbers() {
        return false;
    }

    private static Font lineNumbersFont() {
        return new Font("Courier", 0, 6);
    }

    private static AttributedCharacterIterator[] getIterators(Document doc) {
        if (doc instanceof NbDocument.Printable) {
            return ((NbDocument.Printable)doc).createPrintIterators();
        }
        Font f = new Font("Courier", 0, 8);
        AttributedCharacters achs = null;
        char[] chars = null;
        ArrayList<AttributedCharacterIterator> iterators = new ArrayList<AttributedCharacterIterator>(300);
        try {
            String document = doc.getText(0, doc.getLength());
            int firstCharInDoc = 0;
            int i = 0;
            while (i < document.length()) {
                if (document.charAt(i) == '\n') {
                    chars = new char[i - firstCharInDoc + 1];
                    document.getChars(firstCharInDoc, chars.length + firstCharInDoc, chars, 0);
                    achs = new AttributedCharacters();
                    achs.append(chars, f, Color.black);
                    iterators.add(achs.iterator());
                    firstCharInDoc = i + 1;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(e);
        }
        AttributedCharacterIterator[] iters = new AttributedCharacterIterator[iterators.size()];
        iterators.toArray(iters);
        return iters;
    }

    private static String getFilename(Document doc) {
        String ret = (String)doc.getProperty("title");
        return ret == null ? "UNKNOWN" : ret;
    }

    private static int[] increaseArray(int[] old) {
        int[] ret = new int[2 * old.length];
        System.arraycopy(old, 0, ret, 0, old.length);
        return ret;
    }

    private void createCancellationPanel(final PrinterJob job) {
        this.cancellationPanel = new CancellationPanel(job);
        DialogDescriptor ddesc = new DialogDescriptor((Object)this.cancellationPanel, NbBundle.getMessage(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = DefaultPrintable.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings, "CTL_Print_cancellation"), false, new Object[]{NbBundle.getMessage(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = DefaultPrintable.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings, "CTL_Cancel")}, (Object)NbBundle.getMessage(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = DefaultPrintable.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings, "CTL_Cancel"), 0, new HelpCtx((class$org$openide$text$DefaultPrintable == null ? (class$org$openide$text$DefaultPrintable = DefaultPrintable.class$("org.openide.text.DefaultPrintable")) : class$org$openide$text$DefaultPrintable).getName() + ".cancelDialog"), new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DefaultPrintable.this.setCancelled(job);
                DefaultPrintable.this.closeDialog();
            }
        });
        this.setDialog(DialogDisplayer.getDefault().createDialog(ddesc));
    }

    void closeDialog() {
        if (this.cancellationDialog != null) {
            ((Component)this.cancellationDialog).setVisible(false);
            this.cancellationDialog.dispose();
        }
    }

    void setDialog(Dialog d) {
        d.show();
        d.pack();
        this.cancellationDialog = d;
    }

    void packDialog() {
        if (this.cancellationDialog != null) {
            this.cancellationDialog.pack();
        }
    }

    void setCancelled(PrinterJob job) {
        job.cancel();
    }

    boolean isCancelled(PrinterJob job) {
        return job.isCancelled();
    }

    private static void replaceEmptyIterators(AttributedCharacterIterator[] iters) {
        int i = 0;
        while (i < iters.length) {
            AttributedCharacterIterator achit = iters[i];
            if (achit.getBeginIndex() == achit.getEndIndex()) {
                AttributedCharacters at = new AttributedCharacters();
                at.append(' ', DefaultPrintable.getFontInstance(), Color.white);
                iters[i] = at.iterator();
            }
            ++i;
        }
    }

    static Font getFontInstance() {
        if (fontInstance == null) {
            fontInstance = new Font("Dialog", 0, 14);
        }
        return fontInstance;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class CancellationPanel
    extends JPanel {
        private final PrinterJob job;
        private final JLabel printProgress;
        private final MessageFormat format;
        private final Object[] msgParams;
        static final long serialVersionUID = -6419253408585188541L;
        static /* synthetic */ Class class$org$openide$text$PrintSettings;

        public CancellationPanel(PrinterJob job) {
            if (job == null) {
                throw new IllegalArgumentException();
            }
            this.job = job;
            this.format = new MessageFormat(NbBundle.getMessage(class$org$openide$text$PrintSettings == null ? (class$org$openide$text$PrintSettings = CancellationPanel.class$("org.openide.text.PrintSettings")) : class$org$openide$text$PrintSettings, "CTL_Print_progress"));
            this.msgParams = new Object[1];
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(12, 12, 0, 12));
            this.printProgress = new JLabel();
            this.printProgress.setHorizontalAlignment(0);
            this.add(this.printProgress);
        }

        public void setPageno(int pageno) {
            this.msgParams[0] = new Integer(pageno + 1);
            this.printProgress.setText(this.format.format(this.msgParams));
            this.getAccessibleContext().setAccessibleDescription(this.printProgress.getText());
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

