/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListener;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.TopComponent;

public final class PasteAction
extends CallbackSystemAction {
    static final long serialVersionUID = -6620328110138256516L;
    private static ActSubMenuModel globalModel;
    private static PasteType[] types;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;

    private static synchronized ActSubMenuModel model() {
        if (globalModel == null) {
            globalModel = new ActSubMenuModel(null);
        }
        return globalModel;
    }

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    public String getName() {
        return NbBundle.getMessage(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction, "Paste");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/paste.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu(this, (Actions.SubMenuModel)PasteAction.model(), false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu(this, (Actions.SubMenuModel)PasteAction.model(), true);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    public Object getActionMapKey() {
        return "paste-from-clipboard";
    }

    public void actionPerformed(ActionEvent ev) {
        Action ac;
        PasteType[] arr;
        PasteType t = ev.getSource() instanceof PasteType ? (PasteType)ev.getSource() : ((arr = this.getPasteTypes()) != null && arr.length > 0 ? arr[0] : null);
        if (t == null && (ac = PasteAction.findActionFromActivatedTopComponentMap()) != null) {
            PasteType[] arr2 = (PasteType[])ac.getValue("delegates");
            if (arr2 != null && arr2.length > 0) {
                t = arr2[0];
            } else {
                ac.actionPerformed(ev);
                return;
            }
        }
        if (t != null) {
            PasteAction.executePasteType(t);
        } else {
            ErrorManager.getDefault().notify(1, new IllegalStateException("No paste types available when performing paste action"));
        }
    }

    private static void executePasteType(PasteType t) {
        block11: {
            NodeSelector sel = null;
            try {
                block10: {
                    try {
                        ExplorerManager em = PasteAction.findExplorerManager();
                        if (em != null) {
                            sel = new NodeSelector(em, null);
                        }
                        Transferable trans = t.paste();
                        Clipboard clipboard = PasteAction.getClipboard();
                        if (trans == null) break block10;
                        ClipboardOwner owner = trans instanceof ClipboardOwner ? (ClipboardOwner)((Object)trans) : new StringSelection("");
                        clipboard.setContents(trans, owner);
                    }
                    catch (UserCancelException exc) {
                        Object var7_9 = null;
                        if (sel != null) {
                            sel.select();
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(e);
                        Object var7_10 = null;
                        if (sel != null) {
                            sel.select();
                        }
                    }
                }
                Object var7_8 = null;
                if (sel != null) {
                    sel.select();
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (sel != null) {
                    sel.select();
                }
                throw throwable;
            }
        }
    }

    public void setPasteTypes(PasteType[] types) {
        PasteAction.types = types;
        if (types == null || types.length == 0) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        PasteAction.model().checkStateChanged(true);
    }

    public PasteType[] getPasteTypes() {
        return types;
    }

    private static Action findActionFromActivatedTopComponentMap() {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null) {
            ActionMap map = tc.getActionMap();
            return PasteAction.findActionFromMap(map);
        }
        return null;
    }

    private static Action findActionFromMap(ActionMap map) {
        if (map != null) {
            return map.get("paste-from-clipboard");
        }
        return null;
    }

    private static Clipboard getClipboard() {
        Clipboard c = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = PasteAction.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (c == null) {
            c = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return c;
    }

    static void invokeAction(Action sa, ActionEvent ev) {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.actions.ActionManager");
            Object o = Lookup.getDefault().lookup(c);
            if (o != null) {
                Method m = c.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = PasteAction.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = PasteAction.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                m.invoke(o, sa, ev);
                return;
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        sa.actionPerformed(ev);
    }

    static ExplorerManager findExplorerManager() {
        Exception t = null;
        try {
            Class<?> c = Class.forName("org.openide.windows.TopComponent");
            Method m = c.getMethod("getRegistry", new Class[0]);
            Object o = m.invoke(null, new Object[0]);
            c = Class.forName("org.openide.windows.TopComponent$Registry");
            m = c.getMethod("getActivated", new Class[0]);
            o = m.invoke(o, new Object[0]);
            if (o instanceof ExplorerManager.Provider) {
                return ((ExplorerManager.Provider)o).getExplorerManager();
            }
        }
        catch (ClassNotFoundException x) {
        }
        catch (ExceptionInInitializerError x) {
        }
        catch (LinkageError x) {
        }
        catch (SecurityException x) {
            t = x;
        }
        catch (NoSuchMethodException x) {
            t = x;
        }
        catch (IllegalAccessException x) {
            t = x;
        }
        catch (IllegalArgumentException x) {
            t = x;
        }
        catch (InvocationTargetException x) {
            t = x;
        }
        if (t != null) {
            ErrorManager.getDefault().notify(1, t);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ActionPT
    extends AbstractAction {
        private PasteType t;

        public ActionPT(PasteType t) {
            this.t = t;
        }

        public void actionPerformed(ActionEvent ev) {
            PasteAction.executePasteType(this.t);
        }
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    ChangeListener {
        private PasteAction delegate;
        private ActSubMenuModel model;

        public DelegateAction(PasteAction a, Lookup actionContext) {
            this.delegate = a;
            this.model = new ActSubMenuModel(actionContext);
            this.model.addChangeListener(this);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        public void putValue(String key, Object value) {
        }

        public void actionPerformed(ActionEvent e) {
            if (this.model != null) {
                this.model.performActionAt(0);
            }
        }

        public boolean isEnabled() {
            return this.model != null && this.model.isEnabled();
        }

        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        public void setEnabled(boolean b) {
        }

        public JMenuItem getMenuPresenter() {
            return new Actions.SubMenu(this, (Actions.SubMenuModel)this.model, false);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.SubMenu(this, (Actions.SubMenuModel)this.model, true);
        }

        public Component getToolbarPresenter() {
            return new Actions.ToolbarButton(this);
        }

        public void stateChanged(ChangeEvent evt) {
            super.firePropertyChange("enabled", null, null);
        }
    }

    static final class NodeSelector
    implements NodeListener,
    Runnable {
        private ArrayList added;
        private Node node;
        private ExplorerManager em;
        private Node[] children;

        public NodeSelector(ExplorerManager em, Node[] n) {
            this.em = em;
            if (n != null && n.length > 0) {
                this.node = n[0];
            } else {
                Node[] arr = em.getSelectedNodes();
                if (arr.length != 0) {
                    this.node = arr[0];
                } else {
                    return;
                }
            }
            this.children = this.node.getChildren().getNodes(true);
            this.added = new ArrayList();
            this.node.addNodeListener(this);
        }

        public void select() {
            if (this.added != null) {
                this.node.getChildren().getNodes(true);
                Children.MUTEX.readAccess(this);
            }
        }

        public void run() {
            this.node.removeNodeListener(this);
            if (this.added.isEmpty()) {
                return;
            }
            Node[] arr = this.added.toArray(new Node[0]);
            int i = 0;
            while (i < arr.length) {
                block7: {
                    Node node = arr[i];
                    while (node != null) {
                        if (!node.equals(this.em.getRootContext())) {
                            node = node.getParentNode();
                            continue;
                        }
                        break block7;
                    }
                    return;
                }
                ++i;
            }
            try {
                this.em.setSelectedNodes(arr);
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
            catch (IllegalStateException ex) {
                ErrorManager.getDefault().notify(1, ex);
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
            this.added.addAll(Arrays.asList(ev.getDelta()));
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel,
    LookupListener,
    PropertyChangeListener {
        private Lookup.Result result;
        private boolean enabled;
        private PropertyChangeListener weakL = WeakListener.propertyChange(this, null);
        static /* synthetic */ Class class$javax$swing$ActionMap;
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        public ActSubMenuModel(Lookup lookup) {
            this.attachListenerToChangesInMap(lookup);
        }

        private ActionMap map() {
            if (this.result == null) {
                TopComponent tc = TopComponent.getRegistry().getActivated();
                if (tc != null) {
                    return tc.getActionMap();
                }
            } else {
                Iterator it = this.result.allItems().iterator();
                while (it.hasNext()) {
                    Object o = ((Lookup.Item)it.next()).getInstance();
                    if (!(o instanceof ActionMap)) continue;
                    return (ActionMap)o;
                }
            }
            return null;
        }

        private void attachListenerToChangesInMap(Lookup lookup) {
            if (lookup == null) {
                TopComponent.getRegistry().addPropertyChangeListener(WeakListener.propertyChange(this, TopComponent.getRegistry()));
            } else {
                this.result = lookup.lookup(new Lookup.Template(class$javax$swing$ActionMap == null ? (class$javax$swing$ActionMap = ActSubMenuModel.class$("javax.swing.ActionMap")) : class$javax$swing$ActionMap));
                this.result.addLookupListener(this);
            }
            this.checkStateChanged(false);
        }

        private Object[] getPasteTypesOrActions(Action[] actionToWorkWith) {
            Object obj;
            Action x = PasteAction.findActionFromMap(this.map());
            if (x == null) {
                Object[] arr;
                PasteAction a = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
                if (actionToWorkWith != null) {
                    actionToWorkWith[0] = a;
                }
                if ((arr = a.getPasteTypes()) != null) {
                    return arr;
                }
                return new Object[0];
            }
            if (actionToWorkWith != null) {
                actionToWorkWith[0] = x;
            }
            if ((obj = x.getValue("delegates")) instanceof Object[]) {
                return (Object[])obj;
            }
            return new Object[]{x};
        }

        public boolean isEnabled() {
            Object[] arr = this.getPasteTypesOrActions(null);
            if (arr.length == 1 && arr[0] instanceof Action) {
                return ((Action)arr[0]).isEnabled();
            }
            return arr.length > 0;
        }

        public int getCount() {
            return this.getPasteTypesOrActions(null).length;
        }

        public String getLabel(int index) {
            Object[] arr = this.getPasteTypesOrActions(null);
            if (arr.length <= index) {
                return null;
            }
            if (arr[index] instanceof PasteType) {
                return ((PasteType)arr[index]).getName();
            }
            return (String)((Action)arr[index]).getValue("Name");
        }

        public HelpCtx getHelpCtx(int index) {
            Object[] arr = this.getPasteTypesOrActions(null);
            if (arr.length <= index) {
                return null;
            }
            if (arr[index] instanceof PasteType) {
                return ((PasteType)arr[index]).getHelpCtx();
            }
            Object helpID = ((Action)arr[index]).getValue("helpID");
            if (helpID instanceof String) {
                return new HelpCtx((String)helpID);
            }
            return null;
        }

        public MenuShortcut getMenuShortcut(int index) {
            return null;
        }

        public void performActionAt(int index) {
            Action[] action = new Action[1];
            Object[] arr = this.getPasteTypesOrActions(action);
            if (arr.length <= index) {
                return;
            }
            if (arr[index] instanceof PasteType) {
                PasteType t = (PasteType)arr[index];
                PasteAction.invokeAction(new ActionPT(t), new ActionEvent(t, 1001, "Name"));
                return;
            }
            Action a = (Action)arr[index];
            PasteAction.invokeAction(a, new ActionEvent(a, 1001, "Name"));
        }

        public synchronized void addChangeListener(ChangeListener listener) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        public synchronized void removeChangeListener(ChangeListener listener) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, listener);
        }

        protected void checkStateChanged(boolean fire) {
            boolean en;
            Action[] listen = new Action[1];
            Object[] arr = this.getPasteTypesOrActions(listen);
            Action a = null;
            if (arr.length == 1 && arr[0] instanceof Action) {
                a = (Action)arr[0];
                a.removePropertyChangeListener(this.weakL);
                a.addPropertyChangeListener(this.weakL);
            }
            if (listen[0] != a) {
                listen[0].removePropertyChangeListener(this.weakL);
                listen[0].addPropertyChangeListener(this.weakL);
            }
            if ((en = this.isEnabled()) == this.enabled) {
                return;
            }
            this.enabled = en;
            if (!fire) {
                return;
            }
            Object[] listeners = this.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            ChangeEvent e = new ChangeEvent(this);
            int i = listeners.length - 1;
            while (i >= 0) {
                ((ChangeListener)listeners[i]).stateChanged(e);
                i -= 2;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.checkStateChanged(true);
        }

        public void resultChanged(LookupEvent ev) {
            this.checkStateChanged(true);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

