/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.jms;

import alma.acs.container.ContainerServicesBase;
import com.cosylab.acs.jms.ACSJMSMessage;
import com.cosylab.acs.jms.ACSJMSObjectMessage;
import com.cosylab.acs.jms.ACSJMSTextMessage;
import com.cosylab.acs.jms.ACSJMSTopic;
import com.cosylab.acs.jms.ACSJMSTopicPublisher;
import com.cosylab.acs.jms.ACSJMSTopicSubscriber;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class ACSJMSSession
implements Session {
    protected ContainerServicesBase containerServices;

    public ACSJMSSession(ContainerServicesBase containerServicesBase) {
        if (containerServicesBase == null) {
            throw new IllegalArgumentException("Invalid null ContainerServices");
        }
        this.containerServices = containerServicesBase;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MapMessage createMapMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Message createMessage() throws JMSException {
        return new ACSJMSMessage(this.containerServices);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return new ACSJMSObjectMessage(this.containerServices);
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        ACSJMSObjectMessage aCSJMSObjectMessage = new ACSJMSObjectMessage(serializable, this.containerServices);
        return aCSJMSObjectMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TextMessage createTextMessage() throws JMSException {
        return new ACSJMSTextMessage(this.containerServices);
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        ACSJMSTextMessage aCSJMSTextMessage = new ACSJMSTextMessage(this.containerServices);
        aCSJMSTextMessage.setText(string);
        return aCSJMSTextMessage;
    }

    public boolean getTransacted() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public int getAcknowledgeMode() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void close() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void recover() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return new ACSJMSTopicPublisher((Topic)destination, this.containerServices);
        }
        throw new IllegalArgumentException("Only Topic destinations are supported by ACSJMSSession.");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return new ACSJMSTopicSubscriber((Topic)destination, this.containerServices, null);
        }
        throw new IllegalArgumentException("Only Topic destinations are supported by ACSJMSSession.");
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Queue createQueue(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public Topic createTopic(String string) throws JMSException {
        return new ACSJMSTopic(string);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void unsubscribe(String string) throws JMSException {
        throw new UnsupportedOperationException();
    }
}

