/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.jms;

import com.codestreet.selector.ISelector;
import com.codestreet.selector.Selector;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Identifier;
import com.codestreet.selector.parser.InvalidSelectorException;
import com.codestreet.selector.parser.NumericValue;
import com.codestreet.selector.parser.Result;
import com.cosylab.acs.jms.ACSJMSMessage;

public class ACSJMSMessageSelector {
    private String selectorString;
    private ISelector selector = null;

    public ACSJMSMessageSelector(String string) throws InvalidSelectorException {
        this.setSelectorString(string);
    }

    public String getSelectorString() {
        return this.selectorString;
    }

    public void setSelectorString(String string) throws InvalidSelectorException {
        this.selectorString = string;
        this.selector = this.selectorString == null ? null : (this.selectorString.trim().length() == 0 ? null : Selector.getInstance((String)this.selectorString));
    }

    public boolean match(ACSJMSMessage aCSJMSMessage) {
        if (this.selectorString == null) {
            return true;
        }
        if (this.selectorString.length() == 0) {
            return true;
        }
        ACSJMSValueProvider aCSJMSValueProvider = new ACSJMSValueProvider(aCSJMSMessage);
        Result result = this.selector.eval((IValueProvider)aCSJMSValueProvider, null);
        return result == Result.RESULT_TRUE;
    }

    private class ACSJMSValueProvider
    implements IValueProvider {
        ACSJMSMessage message;

        public ACSJMSValueProvider(ACSJMSMessage aCSJMSMessage) {
            this.message = aCSJMSMessage;
        }

        public Object getValue(Object object, Object object2) {
            if (!(object instanceof Identifier)) {
                throw new IllegalArgumentException("Wrong class " + object.getClass().getName() + " for identifier!");
            }
            String string = ((Identifier)object).getIdentifier().trim();
            if (string.length() == 0) {
                throw new IllegalArgumentException("The identifier can't be empty!");
            }
            Object object3 = null;
            for (int i = 0; i < this.message.entity.properties.length; ++i) {
                if (!this.message.entity.properties[i].property_name.trim().equals(string)) continue;
                object3 = this.message.entity.properties[i].property_value;
                break;
            }
            if (object3 == null) {
                return null;
            }
            try {
                NumericValue numericValue = new NumericValue((Integer)object3);
                return numericValue;
            }
            catch (Exception exception) {
                try {
                    NumericValue numericValue = new NumericValue((Long)object3);
                    return numericValue;
                }
                catch (Exception exception2) {
                    try {
                        NumericValue numericValue = new NumericValue((Float)object3);
                        return numericValue;
                    }
                    catch (Exception exception3) {
                        try {
                            NumericValue numericValue = new NumericValue((Double)object3);
                            return numericValue;
                        }
                        catch (Exception exception4) {
                            String string2 = object3.toString().trim();
                            if (string2.compareToIgnoreCase("true") == 0) {
                                return true;
                            }
                            if (string2.compareToIgnoreCase("false") == 0) {
                                return false;
                            }
                            return string2;
                        }
                    }
                }
            }
        }
    }
}

