/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.launch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.launch.LaunchException;
import org.apache.tools.ant.launch.Locator;

public class Launcher {
    public static final String ANTHOME_PROPERTY = "ant.home";
    public static final String ANTLIBDIR_PROPERTY = "ant.library.dir";
    public static final String ANT_PRIVATEDIR = ".ant";
    public static final String ANT_PRIVATELIB = "lib";
    public static final String USER_LIBDIR = ".ant" + File.separatorChar + "lib";
    public static final String MAIN_CLASS = "org.apache.tools.ant.Main";
    public static final String USER_HOMEDIR = "user.home";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    protected static final int EXIT_CODE_ERROR = 2;

    public static void main(String[] stringArray) {
        int n;
        try {
            Launcher launcher = new Launcher();
            n = launcher.run(stringArray);
        }
        catch (LaunchException launchException) {
            n = 2;
            System.err.println(launchException.getMessage());
        }
        catch (Throwable throwable) {
            n = 2;
            throwable.printStackTrace(System.err);
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    private void addPath(String string, boolean bl, List list) throws MalformedURLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (string2.indexOf("%") != -1 && !file.exists()) continue;
            if (bl && file.isDirectory()) {
                URL[] uRLArray = Locator.getLocationURLs(file);
                for (int i = 0; i < uRLArray.length; ++i) {
                    list.add(uRLArray[i]);
                }
            }
            list.add(Locator.fileToURL(file));
        }
    }

    private int run(String[] stringArray) throws LaunchException, MalformedURLException {
        String string = System.getProperty(ANTHOME_PROPERTY);
        File file = null;
        File file2 = Locator.getClassSource(this.getClass());
        File file3 = file2.getParentFile();
        String string2 = MAIN_CLASS;
        if (string != null) {
            file = new File(string);
        }
        if (file == null || !file.exists()) {
            file = file3.getParentFile();
            System.setProperty(ANTHOME_PROPERTY, file.getAbsolutePath());
        }
        if (!file.exists()) {
            throw new LaunchException("Ant home is set incorrectly or ant could not be located");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-lib")) {
                if (i == stringArray.length - 1) {
                    throw new LaunchException("The -lib argument must be followed by a library location");
                }
                arrayList.add(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-cp")) {
                if (i == stringArray.length - 1) {
                    throw new LaunchException("The -cp argument must be followed by a classpath expression");
                }
                if (string3 != null) {
                    throw new LaunchException("The -cp argument must not be repeated");
                }
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("--nouserlib") || stringArray[i].equals("-nouserlib")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--noclasspath") || stringArray[i].equals("-noclasspath")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equals("-main")) {
                if (i == stringArray.length - 1) {
                    throw new LaunchException("The -main argument must be followed by a library location");
                }
                string2 = stringArray[++i];
                continue;
            }
            arrayList2.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList2.size() == stringArray.length ? stringArray : arrayList2.toArray(new String[arrayList2.size()]);
        URL[] uRLArray = this.getLibPathURLs(bl2 ? null : string3, arrayList);
        URL[] uRLArray2 = this.getSystemURLs(file3);
        URL[] uRLArray3 = bl ? new URL[]{} : this.getUserURLs();
        URL[] uRLArray4 = this.getJarArray(uRLArray, uRLArray3, uRLArray2, Locator.getToolsJar());
        StringBuffer stringBuffer = new StringBuffer(System.getProperty(JAVA_CLASS_PATH));
        if (stringBuffer.charAt(stringBuffer.length() - 1) == File.pathSeparatorChar) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        for (int i = 0; i < uRLArray4.length; ++i) {
            stringBuffer.append(File.pathSeparatorChar);
            stringBuffer.append(Locator.fromURI(uRLArray4[i].toString()));
        }
        System.setProperty(JAVA_CLASS_PATH, stringBuffer.toString());
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray4);
        Thread.currentThread().setContextClassLoader(uRLClassLoader);
        Class<?> clazz = null;
        int n = 0;
        try {
            clazz = uRLClassLoader.loadClass(string2);
            AntMain antMain = (AntMain)clazz.newInstance();
            antMain.startAnt(stringArray2, null, null);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Incompatible version of " + string2 + " detected");
            File file4 = Locator.getClassSource(clazz);
            System.err.println("Location of this class " + file4);
            n = 2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            n = 2;
        }
        return n;
    }

    private URL[] getLibPathURLs(String string, List list) throws MalformedURLException {
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            this.addPath(string, false, arrayList);
        }
        for (String string2 : list) {
            this.addPath(string2, true, arrayList);
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private URL[] getSystemURLs(File file) throws MalformedURLException {
        File file2 = null;
        String string = System.getProperty(ANTLIBDIR_PROPERTY);
        if (string != null) {
            file2 = new File(string);
        }
        if (file2 == null || !file2.exists()) {
            file2 = file;
            System.setProperty(ANTLIBDIR_PROPERTY, file2.getAbsolutePath());
        }
        return Locator.getLocationURLs(file2);
    }

    private URL[] getUserURLs() throws MalformedURLException {
        File file = new File(System.getProperty(USER_HOMEDIR), USER_LIBDIR);
        return Locator.getLocationURLs(file);
    }

    private URL[] getJarArray(URL[] uRLArray, URL[] uRLArray2, URL[] uRLArray3, File file) throws MalformedURLException {
        int n = uRLArray.length + uRLArray2.length + uRLArray3.length;
        if (file != null) {
            ++n;
        }
        URL[] uRLArray4 = new URL[n];
        System.arraycopy(uRLArray, 0, uRLArray4, 0, uRLArray.length);
        System.arraycopy(uRLArray2, 0, uRLArray4, uRLArray.length, uRLArray2.length);
        System.arraycopy(uRLArray3, 0, uRLArray4, uRLArray2.length + uRLArray.length, uRLArray3.length);
        if (file != null) {
            uRLArray4[uRLArray4.length - 1] = Locator.fileToURL(file);
        }
        return uRLArray4;
    }
}

