/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Replace
extends Modification {
    public Replace(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process() throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        if (children.getLength() > 1) {
            throw new EXistException("xupdate:replace requires exactly one content node");
        }
        LOG.debug((Object)"processing replace ...");
        int modifications = children.getLength();
        try {
            NodeImpl[] ql = this.selectAndLock();
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NodeImpl doc = null;
            Collection collection = null;
            Collection prevCollection = null;
            DocumentSet modifiedDocs = new DocumentSet();
            for (int i = 0; i < ql.length; ++i) {
                NodeImpl node = ql[i];
                if (node == null) {
                    LOG.warn((Object)("select " + this.selectStmt + " returned empty node set"));
                    continue;
                }
                doc = (DocumentImpl)node.getOwnerDocument();
                ((DocumentImpl)doc).setIndexListener(listener);
                modifiedDocs.add((DocumentImpl)doc);
                collection = ((DocumentImpl)doc).getCollection();
                if (!((DocumentImpl)doc).getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                if (prevCollection != null && collection != prevCollection) {
                    doc.getBroker().saveCollection(prevCollection);
                }
                ElementImpl parent = (ElementImpl)node.getParentNode();
                switch (node.getNodeType()) {
                    case 1: {
                        if (modifications == 0) {
                            modifications = 1;
                        }
                        Node temp = children.item(0);
                        parent.replaceChild(temp, node);
                        break;
                    }
                    case 3: {
                        Node temp = children.item(0);
                        TextImpl text = new TextImpl(temp.getNodeValue());
                        modifications = 1;
                        text.setOwnerDocument((Document)((Object)doc));
                        parent.updateChild(node, text);
                        break;
                    }
                    case 2: {
                        AttrImpl attr = (AttrImpl)node;
                        Node temp = children.item(0);
                        AttrImpl attribute = new AttrImpl(attr.getQName(), temp.getNodeValue());
                        attribute.setOwnerDocument((Document)((Object)doc));
                        parent.updateChild(node, attribute);
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                ((DocumentImpl)doc).setLastModified(System.currentTimeMillis());
                prevCollection = collection;
            }
            if (doc != null) {
                doc.getBroker().saveCollection(collection);
            }
            this.checkFragmentation(modifiedDocs);
        }
        finally {
            this.unlockDocuments();
        }
        return modifications;
    }

    public String getName() {
        return "replace";
    }
}

