/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.AttrImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeImpl;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.NodeList;

public class Rename
extends Modification {
    public Rename(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process() throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        int modificationCount = 0;
        try {
            NodeImpl[] ql = this.selectAndLock();
            NodeImpl doc = null;
            Collection collection = null;
            Collection prevCollection = null;
            DocumentSet modifiedDocs = new DocumentSet();
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            String newName = children.item(0).getNodeValue();
            for (int i = 0; i < ql.length; ++i) {
                NodeImpl node = ql[i];
                doc = (DocumentImpl)node.getOwnerDocument();
                collection = ((DocumentImpl)doc).getCollection();
                if (prevCollection != null && collection != prevCollection) {
                    doc.getBroker().saveCollection(prevCollection);
                }
                if (!collection.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("write access to collection denied; user=" + this.broker.getUser().getName());
                }
                if (!((DocumentImpl)doc).getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission denied to update document");
                }
                ((DocumentImpl)doc).setIndexListener(listener);
                modifiedDocs.add((DocumentImpl)doc);
                NodeImpl parent = (NodeImpl)node.getParentNode();
                switch (node.getNodeType()) {
                    case 1: {
                        ((ElementImpl)node).setNodeName(new QName(newName, "", null));
                        parent.updateChild(node, node);
                        ++modificationCount;
                        break;
                    }
                    case 2: {
                        ((AttrImpl)node).setNodeName(new QName(newName, "", null));
                        parent.updateChild(node, node);
                        ++modificationCount;
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                ((DocumentImpl)doc).clearIndexListener();
                ((DocumentImpl)doc).setLastModified(System.currentTimeMillis());
                prevCollection = collection;
            }
            if (doc != null) {
                doc.getBroker().saveCollection(collection);
            }
            this.checkFragmentation(modifiedDocs);
        }
        finally {
            this.unlockDocuments();
        }
        return modificationCount;
    }

    public String getName() {
        return "rename";
    }
}

