/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.NodeList;

public class Append
extends Modification {
    private int child;

    public Append(DBBroker broker, DocumentSet docs, String selectStmt, String childAttr, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
        this.child = childAttr == null || childAttr.equals("last()") ? -1 : Integer.parseInt(childAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process() throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        try {
            NodeImpl[] ql = this.selectAndLock();
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            Collection collection = null;
            Collection prevCollection = null;
            DocumentImpl doc = null;
            DocumentSet modifiedDocs = new DocumentSet();
            for (int i = 0; i < ql.length; ++i) {
                NodeImpl node = ql[i];
                doc = (DocumentImpl)node.getOwnerDocument();
                doc.setIndexListener(listener);
                modifiedDocs.add(doc);
                collection = doc.getCollection();
                if (prevCollection != null && collection != prevCollection) {
                    this.broker.saveCollection(prevCollection);
                }
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                node.appendChildren(children, this.child);
                doc.clearIndexListener();
                doc.setLastModified(System.currentTimeMillis());
                prevCollection = collection;
            }
            if (doc != null) {
                this.broker.saveCollection(collection);
            }
            this.checkFragmentation(modifiedDocs);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments();
        }
    }

    public String getName() {
        return "append";
    }
}

