/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class YearMonthDurationValue
extends DurationValue {
    public YearMonthDurationValue(int months) {
        if (months < 0) {
            this.negative = true;
            months *= -1;
        }
        this.year = months / 12;
        this.month = months % 12;
    }

    public YearMonthDurationValue(DurationValue other) {
        this.year = other.year;
        this.month = other.month;
    }

    public YearMonthDurationValue(String str) throws XPathException {
        if (str.length() < 3) {
            throw new XPathException("Type error: xs:duration should start with [+|-]P");
        }
        StringBuffer buf = new StringBuffer();
        int state = 0;
        int value = -1;
        block7: for (int p = 0; p < str.length(); ++p) {
            char ch = str.charAt(p);
            switch (ch) {
                case '-': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:yearMonthDuration: " + str + ": - is not allowed here");
                    }
                    this.negative = true;
                    continue block7;
                }
                case 'P': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:yearMonthDuration: " + str + ": P is not allowed here");
                    }
                    ++state;
                    continue block7;
                }
                case 'Y': {
                    if (state != 1 || value < 0) {
                        throw new XPathException("Type error in xs:yearMonthDuration: " + str + ": Y is not allowed to occur here");
                    }
                    this.year = value;
                    value = -1;
                    ++state;
                    continue block7;
                }
                case 'M': {
                    if (state > 2 || value < 0) {
                        throw new XPathException("Type error in xs:yearMonthDuration: " + str + ": M is not allowed to occur here");
                    }
                    this.month = value;
                    ++state;
                    value = -1;
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state < 1) {
                        throw new XPathException("Type error in xs:yearMonthDuration: " + str + ": numeric value not allowed at this position");
                    }
                    buf.append(ch);
                    ++p;
                    while (p < str.length()) {
                        ch = str.charAt(p);
                        if (ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != '5' && ch != '6' && ch != '7' && ch != '8' && ch != '9' && ch != '0') {
                            value = Integer.parseInt(buf.toString());
                            buf.setLength(0);
                            --p;
                            continue block7;
                        }
                        buf.append(ch);
                        ++p;
                    }
                    continue block7;
                }
            }
        }
    }

    public int getValue() {
        int value = this.year * 12 + this.month;
        return this.negative ? -value : value;
    }

    public int getType() {
        return 54;
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        if (this.negative) {
            buf.append('-');
        }
        buf.append('P');
        if (this.year > 0) {
            buf.append(this.year).append('Y');
        }
        if (this.month > 0) {
            buf.append(this.month).append('M');
        }
        return buf.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 54: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 53: {
                return new DurationValue(this);
            }
        }
        throw new XPathException("Type error: cannot cast xs:yearMonthDuration to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 54) {
            int v1 = this.getValue();
            int v2 = ((YearMonthDurationValue)other).getValue();
            switch (operator) {
                case 4: {
                    return v1 == v2;
                }
                case 5: {
                    return v1 != v2;
                }
                case 0: {
                    return v1 < v2;
                }
                case 3: {
                    return v1 <= v2;
                }
                case 1: {
                    return v1 > v2;
                }
                case 2: {
                    return v1 >= v2;
                }
            }
            throw new XPathException("Unknown operator type in comparison");
        }
        throw new XPathException("Type error: cannot compare xs:yearMonthDuration to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 54) {
            int v2;
            int v1 = this.getValue();
            if (v1 == (v2 = ((YearMonthDurationValue)other).getValue())) {
                return 0;
            }
            if (v1 < v2) {
                return -1;
            }
            return 1;
        }
        throw new XPathException("Type error: cannot compare xs:yearMonthDuration to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 54) {
            return this.compareTo(null, other) > 0 ? this : other;
        }
        return this.compareTo(null, other.convertTo(54)) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 54) {
            return this.compareTo(null, other) < 0 ? this : other;
        }
        return this.compareTo(null, other.convertTo(54)) < 0 ? this : other;
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: {
                return new YearMonthDurationValue(this.getValue() + ((YearMonthDurationValue)other).getValue());
            }
            case 51: {
                return ((DateValue)other).plus(this);
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:yearMonthDuration, xs:date, or xs:dateTime; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: {
                return new YearMonthDurationValue(this.getValue() - ((YearMonthDurationValue)other).getValue());
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:yearMonthDuration, xs:date, or xs:dateTime; got: " + Type.getTypeName(other.getType()));
    }
}

