/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.apache.oro.text.perl.Perl5Util;
import org.exist.dom.QName;
import org.exist.util.Collations;
import org.exist.util.XMLChar;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    protected int type = 22;
    protected String value;

    public StringValue(String stringValue, int type) throws XPathException {
        this.type = type;
        if (type == 22) {
            this.value = stringValue;
        } else if (type == 61) {
            this.value = StringValue.normalizeWhitespace(stringValue);
        } else {
            this.value = StringValue.collapseWhitespace(stringValue);
            this.checkType();
        }
    }

    public StringValue(String stringValue) {
        this.value = stringValue;
    }

    public StringValue expand() throws XPathException {
        this.value = StringValue.expand(this.value);
        return this;
    }

    private void checkType() throws XPathException {
        switch (this.type) {
            case 60: 
            case 61: {
                return;
            }
            case 62: {
                Perl5Util util = new Perl5Util();
                String regex = "/(([a-z]|[A-Z])([a-z]|[A-Z])|([iI]-([a-z]|[A-Z])+)|([xX]-([a-z]|[A-Z])+))(-([a-z]|[A-Z])+)*/";
                if (!util.match(regex, this.value)) {
                    throw new XPathException("Type error: string " + this.value + " is not valid for type xs:language");
                }
                return;
            }
            case 64: {
                if (!QName.isQName(this.value)) {
                    throw new XPathException("Type error: string " + this.value + " is not a valid xs:Name");
                }
                return;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                if (!XMLChar.isValidNCName(this.value)) {
                    throw new XPathException("Type error: string " + this.value + " is not a valid " + Type.getTypeName(this.type));
                }
            }
            case 63: {
                if (XMLChar.isValidNmtoken(this.value)) break;
                throw new XPathException("Type error: string " + this.value + " is not a valid xs:NMTOKEN");
            }
        }
    }

    public int getType() {
        return 22;
    }

    public String getStringValue() {
        return this.value;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 22: {
                return this;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return new StringValue(this.value, requiredType);
            }
            case 25: {
                return new AnyURIValue(this.value);
            }
            case 23: {
                if (this.value.equals("0") || this.value.equals("false")) {
                    return BooleanValue.FALSE;
                }
                if (this.value.equals("1") || this.value.equals("true")) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException("cannot convert string '" + this.value + "' to boolean");
            }
            case 30: 
            case 33: 
            case 34: {
                return new DoubleValue(this.value);
            }
            case 32: {
                return new DecimalValue(this.value);
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value, requiredType);
            }
            case 50: {
                return new DateTimeValue(this.value);
            }
            case 52: {
                return new TimeValue(this.value);
            }
            case 51: {
                return new DateValue(this.value);
            }
            case 53: {
                return new DurationValue(this.value);
            }
            case 54: {
                return new YearMonthDurationValue(this.value);
            }
            case 55: {
                return new DayTimeDurationValue(this.value);
            }
        }
        throw new XPathException("cannot convert string '" + this.value + "' to " + Type.getTypeName(requiredType));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(StringValue.class)) {
            return 0;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 1;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(StringValue.class)) {
            return this;
        }
        if (target == Object.class || target == String.class || target == CharSequence.class) {
            return this.value;
        }
        if (target == Double.TYPE || target == Double.class) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return new Double(v.getValue());
        }
        if (target == Float.TYPE || target == Float.class) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return new Float(v.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            IntegerValue v = (IntegerValue)this.convertTo(37);
            return new Long(v.getInt());
        }
        if (target == Integer.TYPE || target == Integer.class) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer(v.getInt());
        }
        if (target == Short.TYPE || target == Short.class) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getInt());
        }
        if (target == Byte.TYPE || target == Byte.class) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getInt());
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        if (target == Character.TYPE || target == Character.class) {
            if (this.value.length() > 1 || this.value.length() == 0) {
                throw new XPathException("cannot convert string with length = 0 or length > 1 to Java character");
            }
            return new Character(this.value.charAt(0));
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.type) + " to Java object of type " + target.getName());
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 22)) {
            boolean substringCompare = false;
            if (operator == 4) {
                String otherVal = other.getStringValue();
                int truncation = -1;
                if (otherVal.length() > 0 && otherVal.charAt(0) == '%') {
                    otherVal = otherVal.substring(1);
                    truncation = 1;
                }
                if (otherVal.length() > 1 && otherVal.charAt(otherVal.length() - 1) == '%') {
                    otherVal = otherVal.substring(0, otherVal.length() - 1);
                    truncation = truncation == 1 ? 2 : 0;
                }
                switch (truncation) {
                    case 2: {
                        return Collations.indexOf(collator, this.value, otherVal) > -1;
                    }
                    case 1: {
                        return Collations.startsWith(collator, this.value, otherVal);
                    }
                    case 0: {
                        return Collations.endsWith(collator, this.value, otherVal);
                    }
                    case -1: {
                        return Collations.equals(collator, this.value, otherVal);
                    }
                }
            }
            int cmp = Collations.compare(collator, this.value, other.getStringValue());
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operand to string value");
        }
        throw new XPathException("Type error: operands are not comparable; expected xs:string; got " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        return Collations.compare(collator, this.value, other.getStringValue());
    }

    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.startsWith(collator, this.value, other.getStringValue());
    }

    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        return Collations.endsWith(collator, this.value, other.getStringValue());
    }

    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        return Collations.indexOf(collator, this.value, other.getStringValue()) > -1;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value.length() > 0;
    }

    public String toString() {
        return this.value;
    }

    public static final String normalizeWhitespace(CharSequence seq) {
        StringBuffer copy = new StringBuffer(seq.length());
        block3: for (int i = 0; i < seq.length(); ++i) {
            char ch = seq.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    copy.append(' ');
                    continue block3;
                }
                default: {
                    copy.append(ch);
                }
            }
        }
        return copy.toString();
    }

    public static String collapseWhitespace(CharSequence in) {
        if (in.length() == 0) {
            return ((Object)in).toString();
        }
        StringBuffer sb = new StringBuffer(in.length());
        boolean inWhitespace = true;
        block3: for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inWhitespace) continue block3;
                    sb.append(' ');
                    inWhitespace = true;
                    continue block3;
                }
                default: {
                    sb.append(c);
                    inWhitespace = false;
                }
            }
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final String expand(CharSequence seq) throws XPathException {
        StringBuffer buf = new StringBuffer(seq.length());
        StringBuffer entityRef = null;
        block3: for (int i = 0; i < seq.length(); ++i) {
            char ch = seq.charAt(i);
            switch (ch) {
                case '&': {
                    if (entityRef == null) {
                        entityRef = new StringBuffer();
                    } else {
                        entityRef.setLength(0);
                    }
                    boolean found = false;
                    for (int j = i + 1; j < seq.length(); ++j) {
                        ch = seq.charAt(j);
                        if (ch == ';') {
                            found = true;
                            i = j;
                            break;
                        }
                        entityRef.append(ch);
                    }
                    if (found) {
                        buf.append(StringValue.expandEntity(entityRef.toString()));
                        continue block3;
                    }
                    buf.append('&');
                    continue block3;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    private static final char expandEntity(String buf) throws XPathException {
        if (buf.equals("amp")) {
            return '&';
        }
        if (buf.equals("lt")) {
            return '<';
        }
        if (buf.equals("gt")) {
            return '>';
        }
        if (buf.equals("quot")) {
            return '\"';
        }
        if (buf.equals("apos")) {
            return '\'';
        }
        if (buf.length() > 1 && buf.charAt(0) == '#') {
            return StringValue.expandCharRef(buf.substring(1));
        }
        throw new XPathException("Unknown entity reference: " + buf);
    }

    private static final char expandCharRef(String buf) throws XPathException {
        try {
            if (buf.length() > 1 && buf.charAt(0) == 'x') {
                return (char)Integer.parseInt(buf.substring(1), 16);
            }
            return (char)Integer.parseInt(buf);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Unknown character reference: " + buf);
        }
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        System.out.println("Comparing " + this.value + " > " + other.getStringValue());
        if (Type.subTypeOf(other.getType(), 22)) {
            return Collations.compare(collator, this.value, ((StringValue)other).value) > 0 ? this : other;
        }
        return Collations.compare(collator, this.value, ((StringValue)other.convertTo((int)this.getType())).value) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 22)) {
            return Collations.compare(collator, this.value, ((StringValue)other).value) < 0 ? this : other;
        }
        return Collations.compare(collator, this.value, ((StringValue)other.convertTo((int)this.getType())).value) < 0 ? this : other;
    }
}

