/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.xquery.Cardinality;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class SequenceType {
    private int primaryType = 11;
    private int cardinality = 2;

    public SequenceType() {
    }

    public SequenceType(int primaryType, int cardinality) {
        this.primaryType = primaryType;
        this.cardinality = cardinality;
    }

    public int getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(int type) {
        this.primaryType = type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void checkType(int type) throws XPathException {
        if (type == 10) {
            return;
        }
        if (!Type.subTypeOf(type, this.primaryType)) {
            throw new XPathException("Type error: expected type: " + Type.getTypeName(this.primaryType) + "; got: " + Type.getTypeName(type));
        }
    }

    public void checkCardinality(Sequence seq) throws XPathException {
        int items = seq.getLength();
        if (items > 0 && this.cardinality == 1) {
            throw new XPathException("Empty sequence expected; got " + items);
        }
        if (items == 0 && (this.cardinality & 1) == 0) {
            throw new XPathException("Empty sequence is not allowed here");
        }
        if (items > 1 && (this.cardinality & 4) == 0) {
            throw new XPathException("Sequence with more than one item is not allowed here");
        }
    }

    public String toString() {
        if (this.cardinality == 1) {
            return "empty()";
        }
        return Type.getTypeName(this.primaryType) + Cardinality.display(this.cardinality);
    }
}

