/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.exist.dom.ContextItem;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.xquery.Expression;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class PreorderedValueSequence
extends AbstractSequence {
    private OrderSpec[] orderSpecs;
    private OrderedNodeProxy[] nodes;

    public PreorderedValueSequence(OrderSpec[] specs, Sequence input) throws XPathException {
        this.orderSpecs = specs;
        this.nodes = new OrderedNodeProxy[input.getLength()];
        int j = 0;
        SequenceIterator i = input.unorderedIterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.nextItem();
            this.nodes[j] = new OrderedNodeProxy(p);
            p.addContextNode(this.nodes[j]);
            ++j;
        }
        this.processAll();
    }

    private void processAll() throws XPathException {
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.orderSpecs.length; ++i) {
            Expression expr = this.orderSpecs[i].getSortExpression();
            expr.setInPredicate(true);
            NodeSet result = expr.eval(null).toNodeSet();
            Iterator j = result.iterator();
            while (j.hasNext()) {
                NodeProxy p = (NodeProxy)j.next();
                for (ContextItem context = p.getContext(); context != null; context = context.getNextItem()) {
                    if (!(context.getNode() instanceof OrderedNodeProxy)) continue;
                    OrderedNodeProxy cp = (OrderedNodeProxy)context.getNode();
                    cp.values[i] = p.atomize();
                    System.out.println(cp.values[i]);
                }
            }
        }
        System.out.println("Sorting took " + (System.currentTimeMillis() - start));
    }

    public int getItemType() {
        return -1;
    }

    public SequenceIterator iterate() {
        this.sort();
        return new PreorderedValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new PreorderedValueSequenceIterator();
    }

    public int getLength() {
        return this.nodes.length;
    }

    public void add(Item item) throws XPathException {
    }

    public Item itemAt(int pos) {
        return this.nodes[pos];
    }

    public NodeSet toNodeSet() throws XPathException {
        return null;
    }

    public void removeDuplicates() {
    }

    private void sort() {
        Arrays.sort(this.nodes, new OrderedComparator());
    }

    private class PreorderedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private PreorderedValueSequenceIterator() {
        }

        public boolean hasNext() {
            return this.pos < PreorderedValueSequence.this.nodes.length;
        }

        public Item nextItem() {
            if (this.pos < PreorderedValueSequence.this.nodes.length) {
                return PreorderedValueSequence.this.nodes[this.pos++];
            }
            return null;
        }
    }

    private class OrderedNodeProxy
    extends NodeProxy {
        AtomicValue[] values;

        public OrderedNodeProxy(NodeProxy p) {
            super(p);
            this.values = new AtomicValue[PreorderedValueSequence.this.orderSpecs.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = AtomicValue.EMPTY_VALUE;
            }
        }
    }

    private class OrderedComparator
    implements Comparator {
        private OrderedComparator() {
        }

        public int compare(Object o1, Object o2) {
            OrderedNodeProxy p1 = (OrderedNodeProxy)o1;
            OrderedNodeProxy p2 = (OrderedNodeProxy)o2;
            int cmp = 0;
            for (int i = 0; i < p1.values.length; ++i) {
                try {
                    AtomicValue a = p1.values[i];
                    AtomicValue b = p2.values[i];
                    cmp = a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (b == AtomicValue.EMPTY_VALUE && a != AtomicValue.EMPTY_VALUE ? ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : a.compareTo(PreorderedValueSequence.this.orderSpecs[i].getCollator(), b));
                    if ((PreorderedValueSequence.this.orderSpecs[i].getModifiers() & 1) != 0) {
                        cmp *= -1;
                    }
                    if (cmp == 0) continue;
                    break;
                }
                catch (XPathException e) {
                    // empty catch block
                }
            }
            return cmp;
        }
    }
}

