/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

public class DurationValue
extends ComputableValue {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    protected boolean negative = false;
    protected int year = 0;
    protected int month = 0;
    protected int day = 0;
    protected int hour = 0;
    protected int minute = 0;
    protected int second = 0;
    protected int millisecond = 0;

    protected DurationValue() {
    }

    public DurationValue(DurationValue other) throws XPathException {
        this.negative = other.negative;
        this.year = other.year;
        this.month = other.month;
        this.day = other.day;
        this.hour = other.hour;
        this.minute = other.minute;
        this.second = other.second;
        this.millisecond = other.millisecond;
    }

    public DurationValue(String str) throws XPathException {
        if (str.length() < 3) {
            throw new XPathException("Type error: xs:duration should start with [+|-]P");
        }
        StringBuffer buf = new StringBuffer();
        int state = 0;
        String value = null;
        block12: for (int p = 0; p < str.length(); ++p) {
            char ch = str.charAt(p);
            switch (ch) {
                case '-': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:duration: " + str + ": - is not allowed here");
                    }
                    this.negative = true;
                    continue block12;
                }
                case 'P': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:duration: " + str + ": P is not allowed here");
                    }
                    ++state;
                    continue block12;
                }
                case 'Y': {
                    if (state != 1 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": Y is not allowed to occur here");
                    }
                    this.year = Integer.parseInt(value);
                    value = null;
                    ++state;
                    continue block12;
                }
                case 'M': {
                    if (value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": M is not allowed to occur here");
                    }
                    if (state == 5 || state == 6) {
                        this.minute = Integer.parseInt(value);
                    } else if (state == 1 || state == 2) {
                        this.month = Integer.parseInt(value);
                    } else {
                        throw new XPathException("Type error in xs:duration: " + str + ": M is not allowed to occur here");
                    }
                    ++state;
                    value = null;
                    continue block12;
                }
                case 'D': {
                    if (state > 3 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": D is not allowed to occur here");
                    }
                    this.day = Integer.parseInt(value);
                    value = null;
                    ++state;
                    continue block12;
                }
                case 'T': {
                    state = 5;
                    continue block12;
                }
                case 'H': {
                    if (state != 5 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": H is not allowed to occur here");
                    }
                    this.hour = Integer.parseInt(value);
                    value = null;
                    ++state;
                    continue block12;
                }
                case 'S': {
                    if (value == null || state > 8) {
                        throw new XPathException("Type error in xs:duration: " + str + ": S is not allowed to occur here");
                    }
                    if (state == 8) {
                        while (value.length() < 3) {
                            value = value + "0";
                        }
                        if (value.length() > 3) {
                            value = value.substring(0, 3);
                        }
                        this.millisecond = Integer.parseInt(value);
                    } else {
                        this.second = Integer.parseInt(value);
                    }
                    value = null;
                    ++state;
                    continue block12;
                }
                case '.': {
                    if (state > 7) {
                        throw new XPathException("Type error in xs:duration: " + str + ": . is not allowed to occur here");
                    }
                    this.second = Integer.parseInt(value);
                    value = null;
                    state = 8;
                    continue block12;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state < 1) {
                        throw new XPathException("Type error in xs:duration: " + str + ": numeric value not allowed at this position");
                    }
                    buf.append(ch);
                    ++p;
                    while (p < str.length()) {
                        ch = str.charAt(p);
                        if (ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != '5' && ch != '6' && ch != '7' && ch != '8' && ch != '9' && ch != '0') {
                            value = buf.toString();
                            buf.setLength(0);
                            --p;
                            continue block12;
                        }
                        buf.append(ch);
                        ++p;
                    }
                    continue block12;
                }
            }
        }
    }

    public int getType() {
        return 53;
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        if (this.negative) {
            buf.append('-');
        }
        buf.append('P');
        if (this.year > 0) {
            buf.append(this.year).append('Y');
        }
        if (this.month > 0) {
            buf.append(this.month).append('M');
        }
        if (this.day > 0) {
            buf.append(this.day).append('D');
        }
        if (this.hour > 0 || this.minute > 0 || this.second > 0) {
            buf.append('T');
        }
        if (this.hour > 0) {
            buf.append(this.hour).append('H');
        }
        if (this.minute > 0) {
            buf.append(this.minute).append('M');
        }
        if (this.second > 0) {
            buf.append(this.second).append('S');
        }
        return buf.toString();
    }

    public int getPart(int part) {
        switch (part) {
            case 0: {
                return this.year;
            }
            case 1: {
                return this.month;
            }
            case 2: {
                return this.day;
            }
            case 3: {
                return this.hour;
            }
            case 4: {
                return this.minute;
            }
            case 5: {
                return this.second;
            }
            case 6: {
                return this.millisecond;
            }
        }
        throw new IllegalArgumentException("Invalid argument to method getPart");
    }

    public double getSeconds() {
        double value = this.second;
        return value += (double)this.millisecond / 1000.0;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 53: {
                return this;
            }
            case 54: {
                return new YearMonthDurationValue(this);
            }
            case 55: {
                return new DayTimeDurationValue(this);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:duration to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        throw new XPathException("xs:duration values cannot be compared. Use xdt:yearMonthDuration or xdt:dayTimeDuration instead");
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("xs:duration values cannot be compared. Use xdt:yearMonthDuration or xdt:dayTimeDuration instead");
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("xs:duration values cannot be compared. Use xdt:yearMonthDuration or xdt:dayTimeDuration instead");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("xs:duration values cannot be compared. Use xdt:yearMonthDuration or xdt:dayTimeDuration instead");
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException("subtraction is not supported for type xs:duration");
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        throw new XPathException("addition is not supported for type xs:duration");
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        throw new XPathException("multiplication is not supported for type xs:duration");
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        throw new XPathException("division is not supported for type xs:duration");
    }
}

