/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class DecimalValue
extends NumericValue {
    BigDecimal value;

    public DecimalValue(BigDecimal decimal) {
        this.value = decimal;
    }

    public DecimalValue(String str) throws XPathException {
        try {
            this.value = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Type error: " + str + " cannot be cast to a decimal");
        }
    }

    public DecimalValue(double val) {
        this.value = new BigDecimal(val);
    }

    public int getType() {
        return 32;
    }

    public String getStringValue() throws XPathException {
        return this.value.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 32: {
                return this;
            }
            case 34: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 33: {
                return new FloatValue(this.value.floatValue());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value.longValue(), requiredType);
            }
            case 23: {
                return this.value.signum() == 0 ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException("cannot convert double value '" + this.value + "' into " + Type.getTypeName(requiredType));
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value.signum() != 0;
    }

    public NumericValue negate() throws XPathException {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue ceiling() throws XPathException {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue floor() throws XPathException {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue round() throws XPathException {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.subtract(((DecimalValue)other).value));
        }
        return ((ComputableValue)this.convertTo(other.getType())).minus(other);
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.add(((DecimalValue)other).value));
        }
        return ((ComputableValue)this.convertTo(other.getType())).plus(other);
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.multiply(((DecimalValue)other).value));
        }
        return ((ComputableValue)this.convertTo(other.getType())).mult(other);
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.divide(((DecimalValue)other).value, 1));
        }
        return ((ComputableValue)this.convertTo(other.getType())).div(other);
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (other.getType() == 32) {
            BigDecimal quotient = this.value.divide(((DecimalValue)other).value, 1);
            BigDecimal remainder = this.value.subtract(quotient.multiply(((DecimalValue)other).value));
            return new DecimalValue(remainder);
        }
        return ((NumericValue)this.convertTo(other.getType())).mod(other);
    }

    public NumericValue abs() throws XPathException {
        return new DecimalValue(this.value.abs());
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.max(((DecimalValue)other).value));
        }
        return new DecimalValue(this.value.max(((DecimalValue)other.convertTo((int)32)).value));
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 32) {
            return new DecimalValue(this.value.min(((DecimalValue)other).value));
        }
        System.out.println(other.getClass().getName());
        return new DecimalValue(this.value.min(((DecimalValue)other.convertTo((int)32)).value));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(DecimalValue.class)) {
            return 0;
        }
        if (javaClass == BigDecimal.class) {
            return 1;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 4;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 5;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 6;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 7;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 2;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 3;
        }
        if (javaClass == String.class) {
            return 8;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 9;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(DecimalValue.class)) {
            return this;
        }
        if (target == BigDecimal.class) {
            return this.value;
        }
        if (target == Double.class || target == Double.TYPE) {
            return new Double(this.value.doubleValue());
        }
        if (target == Float.class || target == Float.TYPE) {
            return new Float(this.value.floatValue());
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getValue());
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

