/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;

public class DayTimeDurationValue
extends DurationValue {
    public DayTimeDurationValue(DurationValue other) throws XPathException {
        this.day = other.day;
        this.hour = other.hour;
        this.minute = other.minute;
        this.second = other.second;
        this.millisecond = other.millisecond;
    }

    public DayTimeDurationValue(long millis) {
        if (millis < 0L) {
            this.negative = true;
            millis *= -1L;
        }
        if (millis > 1000L) {
            this.second = (int)(millis / 1000L);
            this.millisecond = (int)(millis % 1000L);
        } else {
            this.millisecond = (int)millis;
        }
        this.normalize();
    }

    public DayTimeDurationValue(String str) throws XPathException {
        if (str.length() < 3) {
            throw new XPathException("Type error: xs:duration should start with [+|-]P");
        }
        StringBuffer buf = new StringBuffer();
        int state = 0;
        String value = null;
        block11: for (int p = 0; p < str.length(); ++p) {
            char ch = str.charAt(p);
            switch (ch) {
                case '-': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:duration: " + str + ": - is not allowed here");
                    }
                    this.negative = true;
                    continue block11;
                }
                case 'P': {
                    if (state > 0) {
                        throw new XPathException("Type error in xs:duration: " + str + ": P is not allowed here");
                    }
                    ++state;
                    continue block11;
                }
                case 'D': {
                    if (state != 1 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": D is not allowed to occur here");
                    }
                    this.day = Integer.parseInt(value);
                    value = null;
                    ++state;
                    continue block11;
                }
                case 'T': {
                    state = 2;
                    continue block11;
                }
                case 'H': {
                    if (state != 2 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": H is not allowed to occur here");
                    }
                    this.hour = Integer.parseInt(value);
                    value = null;
                    ++state;
                    continue block11;
                }
                case 'M': {
                    if (state > 3 || value == null) {
                        throw new XPathException("Type error in xs:duration: " + str + ": M is not allowed to occur here");
                    }
                    this.minute = Integer.parseInt(value);
                    ++state;
                    value = null;
                    continue block11;
                }
                case 'S': {
                    if (value == null || state > 5) {
                        throw new XPathException("Type error in xs:duration: " + str + ": S is not allowed to occur here");
                    }
                    if (state == 5) {
                        while (value.length() < 3) {
                            value = value + "0";
                        }
                        if (value.length() > 3) {
                            value = value.substring(0, 3);
                        }
                        this.millisecond = Integer.parseInt(value);
                    } else {
                        this.second = Integer.parseInt(value);
                    }
                    value = null;
                    ++state;
                    continue block11;
                }
                case '.': {
                    if (state > 4) {
                        throw new XPathException("Type error in xs:duration: " + str + ": . is not allowed to occur here");
                    }
                    this.second = Integer.parseInt(value);
                    value = null;
                    state = 5;
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state < 1) {
                        throw new XPathException("Type error in xs:duration: " + str + ": numeric value not allowed at this position");
                    }
                    buf.append(ch);
                    ++p;
                    while (p < str.length()) {
                        ch = str.charAt(p);
                        if (ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != '5' && ch != '6' && ch != '7' && ch != '8' && ch != '9' && ch != '0') {
                            value = buf.toString();
                            buf.setLength(0);
                            --p;
                            continue block11;
                        }
                        buf.append(ch);
                        ++p;
                    }
                    continue block11;
                }
                default: {
                    throw new XPathException("Type error in xs:duration: " + str + ": invalid character: " + ch);
                }
            }
        }
    }

    public int getType() {
        return 55;
    }

    public double getValue() {
        double value = this.day;
        value = value * 24.0 + (double)this.hour;
        value = value * 60.0 + (double)this.minute;
        value = value * 60.0 + (double)this.second + (double)this.millisecond / 1000.0;
        if (this.negative) {
            value *= -1.0;
        }
        return value;
    }

    public long getValueInMilliseconds() {
        long value = this.day;
        value = value * 24L + (long)this.hour;
        value = value * 60L + (long)this.minute;
        value = value * 60L + (long)this.second;
        value = value * 1000L + (long)this.millisecond;
        return this.negative ? -value : value;
    }

    public void normalize() {
        if (this.millisecond >= 1000) {
            this.second += this.millisecond / 1000;
            this.millisecond %= 1000;
        }
        if (this.second > 60) {
            this.minute += this.second / 60;
            this.second %= 60;
        }
        if (this.minute > 60) {
            this.hour += this.minute / 60;
            this.minute %= 60;
        }
        if (this.hour > 24) {
            this.day += this.hour / 24;
            this.hour %= 24;
        }
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        if (this.negative) {
            buf.append('-');
        }
        buf.append('P');
        if (this.day > 0) {
            buf.append(this.day).append('D');
        }
        buf.append('T');
        if (this.hour > 0) {
            buf.append(this.hour).append('H');
        }
        if (this.minute > 0) {
            buf.append(this.minute).append('M');
        }
        buf.append(this.second);
        if (this.millisecond > 0) {
            buf.append('.').append(this.millisecond);
        }
        buf.append('S');
        return buf.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 55: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 53: {
                return new DurationValue(this);
            }
        }
        throw new XPathException("Type error: cannot cast xs:dayTimeDuration to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 55) {
            double v1 = this.getValue();
            double v2 = ((DayTimeDurationValue)other).getValue();
            switch (operator) {
                case 4: {
                    return v1 == v2;
                }
                case 5: {
                    return v1 != v2;
                }
                case 0: {
                    return v1 < v2;
                }
                case 3: {
                    return v1 <= v2;
                }
                case 1: {
                    return v1 > v2;
                }
                case 2: {
                    return v1 >= v2;
                }
            }
            throw new XPathException("Unknown operator type in comparison");
        }
        throw new XPathException("Type error: cannot compare xs:dayTimeDuration to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 55) {
            double v2;
            double v1 = this.getValue();
            if (v1 == (v2 = ((DayTimeDurationValue)other).getValue())) {
                return 0;
            }
            if (v1 < v2) {
                return -1;
            }
            return 1;
        }
        throw new XPathException("Type error: cannot compare xs:dayTimeDuration to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 55) {
            return this.compareTo(null, other) > 0 ? this : other;
        }
        return this.compareTo(null, other.convertTo(55)) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 55) {
            return this.compareTo(null, other) < 0 ? this : other;
        }
        return this.compareTo(null, other.convertTo(55)) < 0 ? this : other;
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 55: {
                return new DayTimeDurationValue(this.getValueInMilliseconds() + ((DayTimeDurationValue)other).getValueInMilliseconds());
            }
            case 52: {
                long delta = this.getValueInMilliseconds() + ((TimeValue)other).calendar.getTimeInMillis();
                return new TimeValue(delta, ((TimeValue)other).tzOffset);
            }
            case 50: {
                long delta = this.getValueInMilliseconds() + ((DateTimeValue)other).calendar.getTimeInMillis();
                return new DateTimeValue(delta, ((DateTimeValue)other).tzOffset);
            }
            case 51: {
                long delta = this.getValueInMilliseconds() + ((DateValue)other).calendar.getTimeInMillis();
                return new DateTimeValue(delta, ((DateValue)other).tzOffset);
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:dayTimeDuration, xs:time, xs:date or xs:dateTime; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (other.getType() == 55) {
            return new DayTimeDurationValue(this.getValueInMilliseconds() - ((DayTimeDurationValue)other).getValueInMilliseconds());
        }
        throw new XPathException("Operand to minus should be of type xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }
}

