/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import org.apache.oro.text.perl.Perl5Util;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;

public class DateTimeValue
extends AbstractDateTimeValue {
    private static final String regex = "/(\\+|-)?(\\d{4})-([0-1]\\d)-(\\d{2})T([0-2]\\d):([0-6][0-9]):([0-6][0-9])(\\.(\\d{1,3}))?(.*)/";
    private static final String tzre = "/(\\+|-)?([0-1]\\d):(\\d{2})/";

    public DateTimeValue() {
        this.calendar = new GregorianCalendar();
        this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        this.date = this.calendar.getTime();
    }

    public DateTimeValue(GregorianCalendar cal, int timezone) {
        this.calendar = (GregorianCalendar)cal.clone();
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        this.date = this.calendar.getTime();
    }

    public DateTimeValue(long milliseconds, int timezone) {
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        this.calendar = new GregorianCalendar(zone);
        this.calendar.setLenient(false);
        this.calendar.setTimeInMillis(milliseconds);
        this.calendar.set(15, this.tzOffset * 60000);
        this.date = this.calendar.getTime();
    }

    public DateTimeValue(long milliseconds) {
        this.calendar = new GregorianCalendar();
        this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        this.calendar.setTimeInMillis(milliseconds);
        this.date = this.calendar.getTime();
    }

    public DateTimeValue(String dateTime) throws XPathException {
        Perl5Util util = new Perl5Util();
        if (!util.match(regex, dateTime)) {
            throw new XPathException("Type error: string " + dateTime + " cannot be cast into an xs:dateTime");
        }
        String part = util.group(1);
        int era = 1;
        if (part != null && part.equals("-")) {
            era = -1;
        }
        part = util.group(2);
        int year = Integer.parseInt(part) * era;
        part = util.group(3);
        int month = Integer.parseInt(part);
        part = util.group(4);
        int day = Integer.parseInt(part);
        part = util.group(5);
        int hour = Integer.parseInt(part);
        part = util.group(6);
        int minutes = Integer.parseInt(part);
        part = util.group(7);
        int seconds = Integer.parseInt(part);
        part = util.group(9);
        int millis = 0;
        if (part != null) {
            if (part.length() < 3) {
                part = part + "00";
            }
            if (part.length() > 3) {
                part = part.substring(0, 3);
            }
            millis = Integer.parseInt(part);
        }
        if ((part = util.group(10)) != null && part.length() > 0 && !part.equals("Z")) {
            if (!util.match(tzre, part)) {
                throw new XPathException("Type error: error in  timezone: " + part);
            }
            this.explicitTimeZone = true;
            part = util.group(2);
            this.tzOffset = Integer.parseInt(part) * 60;
            part = util.group(3);
            if (part != null) {
                int tzminute = Integer.parseInt(part);
                this.tzOffset += tzminute;
            }
            if ((part = util.group(1)).equals("-")) {
                this.tzOffset *= -1;
            }
        }
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        if (this.explicitTimeZone) {
            this.calendar = new GregorianCalendar(zone);
        } else {
            this.calendar = new GregorianCalendar();
            this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        }
        this.calendar.setLenient(false);
        this.calendar.set(year, month - 1, day, hour, minutes, seconds);
        this.calendar.set(14, millis);
        if (this.explicitTimeZone) {
            this.calendar.set(15, this.tzOffset * 60000);
        }
        try {
            this.date = this.calendar.getTime();
        }
        catch (Exception e) {
            throw new XPathException("Type error: string " + dateTime + " cannot be cast into an xs:dateTime");
        }
    }

    public int getType() {
        return 50;
    }

    public DateValue adjustToTimezone(int offset) {
        Date date = this.calendar.getTime();
        return new DateValue(date.getTime(), offset);
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        int year = this.calendar.get(1);
        if (year < 0) {
            buf.append('-');
            year *= -1;
        }
        this.formatString(buf, year, year > 9999 ? (this.calendar.get(1) + "").length() : 4);
        buf.append('-');
        this.formatString(buf, this.calendar.get(2) + 1, 2);
        buf.append('-');
        this.formatString(buf, this.calendar.get(5), 2);
        buf.append('T');
        this.formatString(buf, this.calendar.get(11), 2);
        buf.append(':');
        this.formatString(buf, this.calendar.get(12), 2);
        buf.append(':');
        this.formatString(buf, this.calendar.get(13), 2);
        int millis = this.calendar.get(14);
        if (millis != 0) {
            buf.append('.');
            String m = this.calendar.get(14) + "";
            while (m.length() < 3) {
                m = "0" + m;
            }
            while (m.endsWith("0")) {
                m = m.substring(0, m.length() - 1);
            }
            buf.append(m);
        }
        if (this.tzOffset == 0) {
            buf.append('Z');
        } else {
            buf.append(this.tzOffset < 0 ? "-" : "+");
            int tzo = this.tzOffset;
            if (tzo < 0) {
                tzo = -tzo;
            }
            int tzhours = tzo / 60;
            this.formatString(buf, tzhours, 2);
            buf.append(':');
            int tzminutes = tzo % 60;
            this.formatString(buf, tzminutes, 2);
        }
        return buf.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 50: {
                return this;
            }
            case 51: {
                return new DateValue(this.calendar, this.tzOffset);
            }
            case 52: {
                return new TimeValue(this.calendar, this.tzOffset);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:dateTime to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 50) {
            int cmp = this.date.compareTo(((DateTimeValue)other).date);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Unknown operator type in comparison");
        }
        throw new XPathException("Type error: cannot compare xs:dateTime to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 50) {
            return this.date.compareTo(((DateTimeValue)other).date);
        }
        throw new XPathException("Type error: cannot compare xs:dateTime to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 50) {
            return this.date.compareTo(((DateTimeValue)other).date) > 0 ? this : other;
        }
        return this.date.compareTo(((DateTimeValue)other.convertTo((int)50)).date) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 50) {
            return this.date.compareTo(((DateTimeValue)other).date) < 0 ? this : other;
        }
        return this.date.compareTo(((DateTimeValue)other.convertTo((int)50)).date) < 0 ? this : other;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        return null;
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        return null;
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        return null;
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        return null;
    }
}

