/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.storage.DBBroker;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SingleItemIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AtomicValue
implements Item,
Sequence {
    public static final AtomicValue EMPTY_VALUE = new EmptyValue();

    public int getType() {
        return 20;
    }

    public abstract String getStringValue() throws XPathException;

    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public abstract boolean compareTo(Collator var1, int var2, AtomicValue var3) throws XPathException;

    public abstract int compareTo(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue max(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue min(Collator var1, AtomicValue var2) throws XPathException;

    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call starts-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call ends-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call contains on value of type " + Type.getTypeName(this.getType()));
    }

    public int getLength() {
        return 1;
    }

    public int getCardinality() {
        return 2;
    }

    public void removeDuplicates() {
    }

    public SequenceIterator iterate() {
        return new SingleItemIterator(this);
    }

    public SequenceIterator unorderedIterator() {
        return new SingleItemIterator(this);
    }

    public int getItemType() {
        return this.getType();
    }

    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    public Sequence toSequence() {
        return this;
    }

    public void toSAX(DBBroker broker, ContentHandler handler) throws SAXException {
        try {
            String s = this.getStringValue();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        try {
            String s = this.getStringValue();
            receiver.characters(s);
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    public void add(Item item) throws XPathException {
    }

    public void addAll(Sequence other) throws XPathException {
    }

    public AtomicValue atomize() throws XPathException {
        return this;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.getStringValue().length() > 0;
    }

    public NodeSet toNodeSet() throws XPathException {
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to a node set");
    }

    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    public String pprint() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return "";
        }
    }

    public int conversionPreference(Class javaClass) {
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
    }

    public void setSelfAsContext() {
    }

    private static final class EmptyValue
    extends AtomicValue {
        private EmptyValue() {
        }

        public String getStringValue() {
            return "";
        }

        public AtomicValue convertTo(int requiredType) throws XPathException {
            throw new XPathException("cannot convert empty value to " + requiredType);
        }

        public int compareTo(Collator collator, AtomicValue other) throws XPathException {
            if (other instanceof EmptyValue) {
                return 0;
            }
            return -1;
        }

        public Item itemAt(int pos) {
            return null;
        }

        public Sequence toSequence() {
            return this;
        }

        public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        public void add(Item item) throws XPathException {
        }

        public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
            throw new XPathException("Cannot compare operand to empty value");
        }

        public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        public int conversionPreference(Class javaClass) {
            return Integer.MAX_VALUE;
        }

        public Object toJavaObject(Class target) throws XPathException {
            throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
        }
    }
}

