/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;

public abstract class AbstractDateTimeValue
extends ComputableValue {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    protected GregorianCalendar calendar;
    protected int tzOffset = 0;
    protected boolean explicitTimeZone = false;
    protected Date date;

    public abstract String getStringValue() throws XPathException;

    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public abstract boolean compareTo(Collator var1, int var2, AtomicValue var3) throws XPathException;

    public int getPart(int part) {
        switch (part) {
            case 0: {
                return this.calendar.get(1);
            }
            case 1: {
                return this.calendar.get(2) + 1;
            }
            case 2: {
                return this.calendar.get(5);
            }
            case 3: {
                return this.calendar.get(11);
            }
            case 4: {
                return this.calendar.get(12);
            }
            case 5: {
                return this.calendar.get(13);
            }
            case 6: {
                return this.calendar.get(14);
            }
        }
        throw new IllegalArgumentException("Invalid argument to method getPart");
    }

    public long getTimezoneOffset() {
        return this.tzOffset * 60000;
    }

    protected void formatString(StringBuffer buf, int value, int size) {
        String s = "000" + value;
        buf.append(s.substring(s.length() - size));
    }
}

