/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.test;

import java.io.File;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.xmldb.DatabaseInstanceManager;
import org.w3c.dom.Element;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XQueryTest
extends TestCase {
    private static final String NUMBERS_XML = "numbers.xml";
    private static final String URI = "xmldb:exist:///db";
    private static final String numbers = "<test><item id='1'><price>5.6</price><stock>22</stock></item><item id='2'><price>7.4</price><stock>43</stock></item><item id='3'><price>18.4</price><stock>5</stock></item><item id='4'><price>65.54</price><stock>16</stock></item></test>";
    private Collection testCollection;
    private static String attributeXML;
    private static int stringSize;
    private static int nbElem;
    private String file_name = "detail_xml.xml";
    private String xml;
    private Database database;

    public XQueryTest(String arg0) {
        super(arg0);
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            this.database = (Database)cl.newInstance();
            this.database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)this.database);
            Collection root = DatabaseManager.getCollection((String)URI, (String)"admin", null);
            CollectionManagementService service = (CollectionManagementService)root.getService("CollectionManagementService", "1.0");
            this.testCollection = service.createCollection("test");
            XQueryTest.assertNotNull((Object)this.testCollection);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        DatabaseManager.deregisterDatabase((Database)this.database);
        DatabaseInstanceManager dim = (DatabaseInstanceManager)this.testCollection.getService("DatabaseInstanceManager", "1.0");
        dim.shutdown();
        System.out.println("tearDown PASSED");
    }

    public void testFor() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService(NUMBERS_XML, numbers);
            System.out.println("testFor 1: ========");
            String query = "for $f in /*/item return $f";
            ResourceSet result = service.queryResource(NUMBERS_XML, query);
            this.printResult(result);
            XQueryTest.assertEquals((String)("XQuery: " + query), (long)4L, (long)result.getSize());
            System.out.println("testFor 2: ========");
            query = "for $f in /*/item  order by $f ascending  return $f";
            result = service.queryResource(NUMBERS_XML, query);
            this.printResult(result);
            XMLResource resu = (XMLResource)result.getResource(0L);
            XQueryTest.assertEquals((String)("XQuery: " + query), (String)"3", (String)((Element)resu.getContentAsDOM()).getAttribute("id"));
            System.out.println("testFor 3: ========");
            query = "for $f in /*/item  order by $f descending  return $f";
            result = service.queryResource(NUMBERS_XML, query);
            this.printResult(result);
            resu = (XMLResource)result.getResource(0L);
            XQueryTest.assertEquals((String)("XQuery: " + query), (String)"2", (String)((Element)resu.getContentAsDOM()).getAttribute("id"));
            System.out.println("testFor 4: ========");
            query = "for $f in /*/item  order by xs:double($f/price) descending  return $f";
            result = service.queryResource(NUMBERS_XML, query);
            this.printResult(result);
            resu = (XMLResource)result.getResource(0L);
            XQueryTest.assertEquals((String)("XQuery: " + query), (String)"4", (String)((Element)resu.getContentAsDOM()).getAttribute("id"));
        }
        catch (XMLDBException e) {
            System.out.println("testFor(): XMLDBException: " + (Object)((Object)e));
            XQueryTest.fail((String)e.getMessage());
        }
    }

    private String makeString(int n) {
        StringBuffer b = new StringBuffer();
        char c = 'a';
        for (int i = 0; i < n; ++i) {
            b.append(c);
        }
        return b.toString();
    }

    public void testLargeAttributeSimple() {
        try {
            System.out.println("testLargeAttributeSimple 1: ========");
            String large = this.createXMLContentWithLargeString();
            XPathQueryService service = this.storeXMLStringAndGetQueryService(this.file_name, this.xml);
            String query = "doc('" + this.file_name + "') / details/metadata[@docid= '" + large + "' ]";
            ResourceSet result = service.queryResource(this.file_name, query);
            this.printResult(result);
            XQueryTest.assertEquals((String)("XQuery: " + query), (long)nbElem, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testLargeAttributeSimple(): XMLDBException: " + (Object)((Object)e));
            XQueryTest.fail((String)e.getMessage());
        }
    }

    public void testLargeAttributeContains() {
        try {
            System.out.println("testLargeAttributeSimple 1: ========");
            String large = this.createXMLContentWithLargeString();
            XPathQueryService service = this.storeXMLStringAndGetQueryService(this.file_name, this.xml);
            String query = "doc('" + this.file_name + "') / details/metadata[ contains(@docid, 'aa') ]";
            ResourceSet result = service.queryResource(this.file_name, query);
            XQueryTest.assertEquals((String)("XQuery: " + query), (long)nbElem, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testLargeAttributeSimple(): XMLDBException: " + (Object)((Object)e));
            XQueryTest.fail((String)e.getMessage());
        }
    }

    public void testLargeAttributeKeywordOperator() {
        try {
            System.out.println("testLargeAttributeSimple 1: ========");
            String large = this.createXMLContentWithLargeString();
            XPathQueryService service = this.storeXMLStringAndGetQueryService(this.file_name, this.xml);
            String query = "doc('" + this.file_name + "') / details/metadata[ @docid &= '" + large + "' ]";
            ResourceSet result = service.queryResource(this.file_name, query);
            XQueryTest.assertEquals((String)("XQuery: " + query), (long)nbElem, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testLargeAttributeSimple(): XMLDBException: " + (Object)((Object)e));
            XQueryTest.fail((String)e.getMessage());
        }
    }

    private String createXMLContentWithLargeString() {
        String large = this.makeString(stringSize);
        String head = "<details format='xml'>";
        String elem = "<metadata docid='" + large + "'></metadata>";
        String tail = "</details>";
        this.xml = head;
        for (int i = 0; i < nbElem; ++i) {
            this.xml = this.xml + elem;
        }
        this.xml = this.xml + tail;
        System.out.println("XML:\n" + this.xml);
        return large;
    }

    public void testRetrieveLargeAttribute() throws XMLDBException {
        System.out.println("testRetrieveLargeAttribute 1: ========");
        XMLResource res = (XMLResource)this.testCollection.getResource(this.file_name);
        System.out.println("res.getContent(): " + res.getContent());
    }

    public void obsoleteTestLargeAttributeRealFile() {
        try {
            System.out.println("testLargeAttributeRealFile 1: ========");
            String large = "challengesininformationretrievalandlanguagemodelingreportofaworkshopheldatthecenterforintelligentinformationretrievaluniversityofmassachusettsamherstseptember2002-extdocid-howardturtlemarksandersonnorbertfuhralansmeatonjayaslamdragomirradevwesselkraaijellenvoorheesamitsinghaldonnaharmanjaypontejamiecallannicholasbelkinjohnlaffertylizliddyronirosenfeldvictorlavrenkodavidjharperrichschwartzjohnpragerchengxiangzhaijinxixusalimroukosstephenrobertsonandrewmccallumbrucecroftrmanmathasuedumaisdjoerdhiemstraeduardhovyralphweischedelthomashofmannjamesallanchrisbuckleyphilipresnikdavidlewis2003";
            if (attributeXML != null) {
                large = attributeXML;
            }
            String xml = "<details format='xml'><metadata docid='" + large + "'></metadata></details>";
            String FILE_NAME = "detail_xml.xml";
            XPathQueryService service = this.storeXMLStringAndGetQueryService("detail_xml.xml");
            String query = "doc('detail_xml.xml') / details/metadata[@docid= '" + large + "' ]";
            ResourceSet result = service.queryResource("detail_xml.xml", query);
            this.printResult(result);
            XQueryTest.assertEquals((String)("XQuery: " + query), (long)2L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testLargeAttributeRealFile(): XMLDBException: " + (Object)((Object)e));
            XQueryTest.fail((String)e.getMessage());
        }
    }

    private XPathQueryService storeXMLStringAndGetQueryService(String documentName, String content) throws XMLDBException {
        XMLResource doc = (XMLResource)this.testCollection.createResource(documentName, "XMLResource");
        doc.setContent((Object)content);
        this.testCollection.storeResource((Resource)doc);
        XPathQueryService service = (XPathQueryService)this.testCollection.getService("XPathQueryService", "1.0");
        return service;
    }

    private XPathQueryService storeXMLStringAndGetQueryService(String documentName) throws XMLDBException {
        XMLResource doc = (XMLResource)this.testCollection.createResource(documentName, "XMLResource");
        doc.setContent((Object)new File(documentName));
        this.testCollection.storeResource((Resource)doc);
        XPathQueryService service = (XPathQueryService)this.testCollection.getService("XPathQueryService", "1.0");
        return service;
    }

    private void printResult(ResourceSet result) throws XMLDBException {
        ResourceIterator i = result.getIterator();
        while (i.hasMoreResources()) {
            Resource r = i.nextResource();
            System.out.println(r.getContent());
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            attributeXML = args[0];
        }
        stringSize = 513;
        if (args.length > 1) {
            stringSize = Integer.parseInt(args[1]);
        }
        nbElem = 2;
        if (args.length > 2) {
            nbElem = Integer.parseInt(args[2]);
        }
        TestRunner.run((Class)XQueryTest.class);
    }
}

