/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.test;

import java.io.File;
import junit.framework.TestCase;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.test.TabularXMLReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class SAXStorageTest
extends TestCase {
    private XMLResource doc;
    private Collection root;
    private static String FILE_STORED;

    public SAXStorageTest(String s) {
        super(s);
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            this.root = DatabaseManager.getCollection((String)"xmldb:exist:///db", (String)"admin", null);
            CollectionManagementService service = (CollectionManagementService)this.root.getService("CollectionManagementService", "1.0");
            this.root = service.createCollection("test");
            FILE_STORED = "big.xml";
            this.doc = (XMLResource)this.root.createResource(FILE_STORED, "XMLResource");
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ResourceSet querySingleLine(String xquery, String mess) throws XMLDBException {
        XPathQueryService service = (XPathQueryService)this.root.getService("XPathQueryService", "1.0");
        ResourceSet result = null;
        if (xquery != "") {
            System.out.println("Querying \"" + xquery + "\" ...");
            long t0 = System.currentTimeMillis();
            result = service.queryResource("big.xml", xquery);
            long t1 = System.currentTimeMillis();
            System.out.println("Time for query \"" + xquery + "\" on " + mess + ": " + (t1 - t0) + " ms.");
        }
        return result;
    }

    public void testQueryStoreContentAsSAX() throws XMLDBException, SAXException {
        ContentHandler databaseInserter = this.doc.setContentAsSAX();
        new TabularXMLReader().writeDocument(databaseInserter);
        this.root.storeResource((Resource)this.doc);
        this.querySingleLine("", "testQueryStoreContentAsSAX");
    }

    public void testQueryBigDocument() throws XMLDBException {
        TabularXMLReader dataSource = new TabularXMLReader();
        this.storeSAXEvents(dataSource);
        ResourceSet result = this.querySingleLine("", "testQueryBigDocument");
        SAXStorageTest.assertEquals((long)1L, (long)result.getSize());
    }

    private void storeSAXEvents(XMLReader dataSource) throws XMLDBException {
        if (this.root instanceof LocalCollection) {
            long t0 = System.currentTimeMillis();
            LocalCollection coll = (LocalCollection)this.root;
            coll.setReader(dataSource);
            this.doc.setContent((Object)new File(FILE_STORED));
            coll.storeResource((Resource)this.doc);
            long t1 = System.currentTimeMillis();
            System.out.println("Time for storing:  " + (t1 - t0) + " ms.");
        }
    }

    public static void main(String[] args) throws XMLDBException {
        String xquery = "";
        int lines = 20;
        int columns = 20;
        if (args.length >= 2) {
            lines = Integer.parseInt(args[0]);
            columns = Integer.parseInt(args[1]);
        }
        if (args.length == 3) {
            xquery = args[2];
        }
        if (args.length < 2) {
            System.out.println("Taking default values");
        }
        SAXStorageTest tester = new SAXStorageTest(null);
        tester.setUp();
        TabularXMLReader dataSource = new TabularXMLReader(lines, columns);
        tester.storeSAXEvents(dataSource);
        System.out.println("Stored tabular data, " + lines + " lines, " + columns + " columns");
        if (xquery != "") {
            ResourceSet result = tester.querySingleLine(xquery, "testQueryBigDocument");
            System.out.println("result size: " + result.getSize());
        }
        SAXStorageTest.shutdown(tester.root);
    }

    private static void shutdown(Collection collection) throws XMLDBException {
        DatabaseInstanceManager manager = (DatabaseInstanceManager)collection.getService("DatabaseInstanceManager", "1.0");
        manager.shutdown();
    }
}

