/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.DOMSerializerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class XMLDBXUpdate
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("update", "http://exist-db.org/xquery/xmldb", "xmldb"), "Process an XUpdate request on the current collection. The first argument specifies the collection object as returned by the collection or create-collection functions. The second argument specifies the XUpdate modifications to be processed. Modifications are passed in a document conforming to the XUpdate specification.", new SequenceType[]{new SequenceType(100, 2), new SequenceType(-1, 2)}, new SequenceType(31, 2));

    public XMLDBXUpdate(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        JavaObjectValue object = (JavaObjectValue)args[0].itemAt(0);
        if (!(object.getObject() instanceof Collection)) {
            throw new XPathException(this.getASTNode(), "Specified Java object is not an XMLDB collection object");
        }
        NodeValue data = (NodeValue)args[1].itemAt(0);
        DOMSerializer serializer = DOMSerializerPool.getInstance().borrowDOMSerializer();
        StringWriter writer = new StringWriter();
        serializer.setWriter(writer);
        Properties properties = new Properties();
        properties.setProperty("indent", "yes");
        serializer.setOutputProperties(properties);
        try {
            serializer.serialize(data.getNode());
        }
        catch (TransformerException e) {
            LOG.debug((Object)"Exception while serializing XUpdate document", (Throwable)e);
            throw new XPathException(this.getASTNode(), "Exception while serializing XUpdate document: " + e.getMessage(), e);
        }
        finally {
            DOMSerializerPool.getInstance().returnDOMSerializer(serializer);
        }
        String xupdate = writer.toString();
        long modifications = 0L;
        try {
            XUpdateQueryService service = (XUpdateQueryService)((Collection)object.getObject()).getService("XUpdateQueryService", "1.0");
            LOG.debug((Object)("Processing XUpdate request: " + xupdate));
            modifications = service.update(xupdate);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "Exception while processing xupdate: " + e.getMessage(), e);
        }
        this.context.getRootExpression().resetState();
        return new IntegerValue(modifications);
    }
}

