/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.File;
import org.exist.dom.QName;
import org.exist.util.DirectoryScanner;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBLoadFromPattern
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store new resources into the database. Resources are read from the server's file system, using the file pattern specified in the second argument. File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one. The first argument denotes the collection where resources should be stored. The collection can be either specified as a simple collection path, an XMLDB URI, or a collection object as returned by the collection or create-collection functions. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2), new SequenceType(22, 6)}, new SequenceType(22, 7)), new FunctionSignature(new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb"), "Store new resources into the database. Resources are read from the server's file system, using the file pattern specified in the second argument. File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one. The first argument denotes the collection where resources should be stored. The collection can be either specified as a simple collection path, an XMLDB URI, or a collection object as returned by the collection or create-collection functions. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document. The final argument $d is used to specify a mime-type.  If the mime-type is something other than 'text/xml' or 'application/xml', the resource will be stored as a binary resource.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2), new SequenceType(22, 6), new SequenceType(22, 2)}, new SequenceType(22, 7))};

    public XMLDBLoadFromPattern(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        String mimeType;
        File baseDir = new File(args[1].getStringValue());
        LOG.debug((Object)("Loading files from directory: " + baseDir));
        Sequence patterns = args[2];
        String resourceType = "XMLResource";
        if (this.getSignature().getArgumentCount() == 4 && !"text/xml".equals(mimeType = args[3].getStringValue()) && !"application/xml".equals(mimeType)) {
            resourceType = "BinaryResource";
        }
        ValueSequence stored = new ValueSequence();
        SequenceIterator i = patterns.iterate();
        while (i.hasNext()) {
            String pattern = i.nextItem().getStringValue();
            File[] files = DirectoryScanner.scanDir(baseDir, pattern);
            for (int j = 0; j < files.length; ++j) {
                try {
                    Resource resource = collection.createResource(files[j].getName(), resourceType);
                    resource.setContent((Object)files[j]);
                    collection.storeResource(resource);
                    stored.add(new StringValue(collection.getName() + '/' + resource.getId()));
                    continue;
                }
                catch (XMLDBException e) {
                    throw new XPathException(this.getASTNode(), "Could not store file " + files[j].getAbsolutePath() + ": " + e.getMessage(), e);
                }
            }
        }
        return stored;
    }
}

