/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBCreateCollection
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("create-collection", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new collection as a child of the collection specified in the first argument. The collection can be passed as a simple collection path, an XMLDB URI or as a collection object (obtained from the collection function).The second argument specifies the name of the new collection.", new SequenceType[]{new SequenceType(11, 2), new SequenceType(22, 2)}, new SequenceType(100, 3));

    public XMLDBCreateCollection(XQueryContext context) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        String collectionName = args[1].getStringValue();
        try {
            CollectionManagementService mgtService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
            Collection newCollection = mgtService.createCollection(collectionName);
            if (newCollection == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return new JavaObjectValue(newCollection);
        }
        catch (XMLDBException e) {
            throw new XPathException(this.getASTNode(), "failed to create new collection " + collectionName + ": " + e.getMessage(), e);
        }
    }
}

