/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

public class XMLDBChangeUser
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("change-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Change properties of an existing user. Parameters are: username, password, group memberships, home collection.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(22, 7), new SequenceType(22, 3)}, new SequenceType(11, 1));

    public XMLDBChangeUser(XQueryContext context) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            try {
                collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), "/db");
                UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
                User oldUser = ums.getUser(userName);
                User user = new User(oldUser.getName());
                if (user == null) {
                    throw new XPathException(this.getASTNode(), "User " + userName + " not found");
                }
                if (args[1].getLength() > 0) {
                    user.setPassword(args[1].getStringValue());
                } else {
                    user.setPasswordDigest(oldUser.getPassword());
                }
                if (args[2].getLength() > 0) {
                    SequenceIterator i = args[2].iterate();
                    while (i.hasNext()) {
                        user.addGroup(i.nextItem().getStringValue());
                    }
                } else {
                    user.setGroups(oldUser.getGroups());
                }
                if (args[3].getLength() > 0) {
                    user.setHome(args[3].getStringValue());
                } else {
                    user.setHome(oldUser.getHome());
                }
                ums.updateUser(user);
            }
            catch (XMLDBException xe) {
                throw new XPathException(this.getASTNode(), "Failed to update user " + userName, xe);
            }
            Object var10_10 = null;
            if (null == collection) return Sequence.EMPTY_SEQUENCE;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (null == collection) throw throwable;
            try {
                collection.close();
                throw throwable;
            }
            catch (XMLDBException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (XMLDBException e) {}
        collection.close();
        return Sequence.EMPTY_SEQUENCE;
    }
}

