/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBAuthenticate
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("authenticate", "http://exist-db.org/xquery/xmldb", "xmldb"), "Check if a user is registered as database user. The function simply tries to read the database collection specified in the first parameter $a, using the supplied username in $b and password in $c. It returns true if the attempt succeeds, false otherwise.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 3), new SequenceType(22, 3)}, new SequenceType(23, 2));

    public XMLDBAuthenticate(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[1].getLength() == 0) {
            return BooleanValue.FALSE;
        }
        String uri = args[0].getStringValue();
        String user = args[1].getStringValue();
        String password = args[2].getStringValue();
        try {
            Collection root = DatabaseManager.getCollection((String)uri, (String)user, (String)password);
            return BooleanValue.TRUE;
        }
        catch (XMLDBException e) {
            return BooleanValue.FALSE;
        }
    }
}

