/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.util.Properties;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.util.ExistVersion;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class SystemProperty
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("system-property", "http://exist-db.org/xquery/util", "util"), "Returns the value of a system property. Similar to the corresponding XSLT function. Predefined properties are: vendor, vendor-url, product-name, product-version, product-build, and all Java system properties.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 3));
    private Properties sysProperties = null;

    public SystemProperty(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String key;
        String value;
        if (this.sysProperties == null) {
            this.sysProperties = new Properties();
            try {
                this.sysProperties.load(ExistVersion.class.getClassLoader().getResourceAsStream("org/exist/system.properties"));
            }
            catch (IOException e) {
                LOG.debug((Object)"Unable to load system.properties from class loader");
            }
        }
        if ((value = this.sysProperties.getProperty(key = args[0].getStringValue())) == null) {
            value = System.getProperty(key);
        }
        return value == null ? Sequence.EMPTY_SEQUENCE : new StringValue(value);
    }
}

