/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class LogFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("log", "http://exist-db.org/xquery/util", "util"), "Logs the message specified in $b to the current logger. $a indicates the log priority, e.g. 'debug' or 'warn'.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 7)}, new SequenceType(11, 1));

    public LogFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        CharSequence message;
        if (args[1].getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String priority = args[0].getStringValue();
        if (args[1].getLength() == 1) {
            message = args[1].getStringValue();
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = args[1].unorderedIterator();
            while (i.hasNext()) {
                buf.append(i.nextItem().getStringValue());
            }
            message = buf;
        }
        if (priority.equalsIgnoreCase("error")) {
            LOG.error((Object)message);
        } else if (priority.equalsIgnoreCase("warn")) {
            LOG.warn((Object)message);
        } else if (priority.equalsIgnoreCase("info")) {
            LOG.info((Object)message);
        } else {
            LOG.debug((Object)message);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

