/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.transform;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.security.PermissionDeniedException;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Transform
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The stylesheet is specified in the second argument. This should either be an URI or a node. Stylesheet parameters may be passed in the third argument using an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>", new SequenceType[]{new SequenceType(-1, 3), new SequenceType(11, 2), new SequenceType(-1, 3)}, new SequenceType(-1, 3));
    private Map cache = new HashMap();

    public Transform(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        TransformerHandler handler;
        if (args[0].getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item inputNode = args[0].itemAt(0);
        Item stylesheetItem = args[1].itemAt(0);
        Node options = null;
        if (args[2].getLength() > 0) {
            options = ((NodeValue)args[2].itemAt(0)).getNode();
        }
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            Templates templates;
            if (Type.subTypeOf(stylesheetItem.getType(), -1)) {
                NodeValue stylesheetNode = (NodeValue)stylesheetItem;
                templates = this.getSource(factory, stylesheetNode);
            } else {
                String stylesheet = stylesheetItem.getStringValue();
                templates = this.getSource((TransformerFactory)factory, stylesheet);
            }
            handler = factory.newTransformerHandler(templates);
            if (options != null) {
                this.parseParameters(options, handler.getTransformer());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new XPathException("Unable to set up transformer: " + e.getMessage(), e);
        }
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        SAXResult result = new SAXResult(receiver);
        handler.setResult(result);
        try {
            handler.startDocument();
            inputNode.toSAX(this.context.getBroker(), handler);
            handler.endDocument();
        }
        catch (SAXException e) {
            throw new XPathException("SAX exception while transforming node: " + e.getMessage(), e);
        }
        Node first = builder.getDocument().getFirstChild();
        this.context.popDocumentContext();
        return (NodeValue)((Object)first);
    }

    private void parseParameters(Node options, Transformer handler) throws XPathException {
        if (options.getNodeType() == 1 && options.getLocalName().equals("parameters")) {
            for (Node child = options.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getLocalName().equals("param")) continue;
                Element elem = (Element)child;
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException("Name or value attribute missing for stylesheet parameter");
                }
                handler.setParameter(name, value);
            }
        }
    }

    private Templates getSource(TransformerFactory factory, String stylesheet) throws XPathException, TransformerConfigurationException {
        int p;
        if (stylesheet.indexOf(58) < 0) {
            File f = new File(stylesheet);
            if (f.canRead()) {
                stylesheet = f.toURI().toASCIIString();
            } else {
                stylesheet = this.context.getBaseURI() + File.separatorChar + stylesheet;
                f = new File(stylesheet);
                if (f.canRead()) {
                    stylesheet = f.toURI().toASCIIString();
                }
            }
        }
        String base = (p = stylesheet.lastIndexOf(47)) > -1 ? stylesheet.substring(0, p) : stylesheet;
        CachedStylesheet cached = (CachedStylesheet)this.cache.get(stylesheet);
        try {
            if (cached == null) {
                cached = new CachedStylesheet(factory, new URL(stylesheet), base);
                this.cache.put(stylesheet, cached);
            }
            return cached.getTemplates();
        }
        catch (MalformedURLException e) {
            throw new XPathException("Malformed URL for stylesheet: " + stylesheet, e);
        }
        catch (IOException e) {
            throw new XPathException("IO error while loading stylesheet: " + stylesheet, e);
        }
    }

    private Templates getSource(SAXTransformerFactory factory, NodeValue stylesheetRoot) throws XPathException, TransformerConfigurationException {
        if (stylesheetRoot.getImplementationType() == 1) {
            factory.setURIResolver(new DatabaseResolver(((NodeProxy)stylesheetRoot).getDocument()));
        }
        TemplatesHandler handler = factory.newTemplatesHandler();
        try {
            handler.startDocument();
            stylesheetRoot.toSAX(this.context.getBroker(), handler);
            handler.endDocument();
            return handler.getTemplates();
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "A SAX exception occurred while compiling the stylesheet: " + e.getMessage(), e);
        }
    }

    private class DatabaseResolver
    implements URIResolver {
        DocumentImpl doc;

        public DatabaseResolver(DocumentImpl myDoc) {
            this.doc = myDoc;
        }

        public Source resolve(String href, String base) throws TransformerException {
            DocumentImpl xslDoc;
            Collection collection = this.doc.getCollection();
            String path = href.startsWith("/") ? href : collection.getName() + '/' + href;
            try {
                xslDoc = (DocumentImpl)Transform.this.context.getBroker().getDocument(path);
                if (!xslDoc.getPermissions().validate(Transform.this.context.getUser(), 4)) {
                    throw new TransformerException("Insufficient privileges to read resource " + path);
                }
            }
            catch (PermissionDeniedException e) {
                throw new TransformerException(e.getMessage(), e);
            }
            if (xslDoc == null) {
                LOG.debug((Object)("Document " + href + " not found in collection " + collection.getName()));
                return null;
            }
            DOMSource source = new DOMSource(xslDoc);
            return source;
        }
    }

    private class ExternalResolver
    implements URIResolver {
        private String baseURI;

        public ExternalResolver(String base) {
            this.baseURI = base;
        }

        public Source resolve(String href, String base) throws TransformerException {
            try {
                URL url = new URL(this.baseURI + '/' + href);
                URLConnection connection = url.openConnection();
                return new StreamSource(connection.getInputStream());
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private class CachedStylesheet {
        TransformerFactory factory;
        long lastModified = -1L;
        Templates templates = null;
        URL url;

        public CachedStylesheet(TransformerFactory factory, URL url, String baseURI) throws TransformerConfigurationException, IOException {
            this.factory = factory;
            this.url = url;
            factory.setURIResolver(new ExternalResolver(baseURI));
            this.getTemplates();
        }

        public Templates getTemplates() throws TransformerConfigurationException, IOException {
            URLConnection connection = this.url.openConnection();
            long modified = connection.getLastModified();
            if (this.templates == null || modified > this.lastModified || modified == 0L) {
                LOG.debug((Object)("compiling stylesheet " + this.url.toString()));
                this.templates = this.factory.newTemplates(new StreamSource(connection.getInputStream()));
            }
            this.lastModified = modified;
            return this.templates;
        }
    }
}

