/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class MatchCount
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("match-count", "http://exist-db.org/xquery/text", "text"), "Counts the number of fulltext matches within the nodes and subnodes in $a.", new SequenceType[]{new SequenceType(-1, 3)}, new SequenceType(31, 2));

    public MatchCount(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].getLength() == 0) {
            return IntegerValue.ZERO;
        }
        int count = 0;
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!Type.subTypeOf(next.getType(), -1)) continue;
            NodeValue nv = (NodeValue)next;
            if (nv.getImplementationType() != 1) {
                throw new XPathException(this.getName() + " cannot be applied to XQuery-constructed nodes.");
            }
            NodeProxy np = (NodeProxy)nv;
            for (Match nextMatch = np.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
                count += nextMatch.getFrequency();
            }
        }
        return new IntegerValue(count);
    }
}

