/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.storage.TermMatcher;

public class FuzzyMatcher
implements TermMatcher {
    private String searchTerm;
    private int termLength;
    private double threshold = 0.5;
    private int[][] e = new int[1][1];

    public FuzzyMatcher(String searchTerm, double threshold) {
        this.searchTerm = searchTerm;
        this.termLength = searchTerm.length();
        this.threshold = threshold;
    }

    public boolean matches(String text) {
        if (this.searchTerm.equalsIgnoreCase(text)) {
            return true;
        }
        int textlen = text.length();
        int dist = this.editDistance(text, this.searchTerm, textlen, this.termLength);
        double distance = 1.0 - (double)dist / (double)Math.min(textlen, this.termLength);
        return distance > this.threshold;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int editDistance(String s, String t, int n, int m) {
        int j;
        int i;
        if (this.e.length <= n || this.e[0].length <= m) {
            this.e = new int[Math.max(this.e.length, n + 1)][Math.max(this.e[0].length, m + 1)];
        }
        int[][] d = this.e;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                d[i][j] = s_i != t.charAt(j - 1) ? FuzzyMatcher.min(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1]) + 1 : FuzzyMatcher.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1]);
            }
        }
        return d[n][m];
    }
}

